/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import restx.build.GAV;
import restx.build.ModuleDependency;
import restx.build.ModuleDescriptor;
import restx.build.ModuleFragment;
import restx.build.RestxBuild;
import restx.build.RestxBuildHelper;
import restx.build.org.json.JSONArray;
import restx.build.org.json.JSONObject;
import restx.build.org.json.JSONTokener;

public class RestxJsonSupport
implements RestxBuild.Parser,
RestxBuild.Generator {
    private final Generator generator = new Generator();
    private final Parser parser = new Parser();

    @Override
    public void generate(ModuleDescriptor md, Writer w) throws IOException {
        this.generator.generate(md, w);
    }

    @Override
    public ModuleDescriptor parse(InputStream inputStream) throws IOException {
        return this.parser.parse(inputStream);
    }

    @Override
    public ModuleDescriptor parse(Path path) throws IOException {
        return this.parser.parse(path);
    }

    @Override
    public String getDefaultFileName() {
        return "md.restx.json";
    }

    static class Parser {
        Parser() {
        }

        public ModuleDescriptor parse(Path path) throws IOException {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                ModuleDescriptor moduleDescriptor = this.parse(path, inputStream);
                return moduleDescriptor;
            }
        }

        public ModuleDescriptor parse(InputStream inputStream) throws IOException {
            return this.parse(null, inputStream);
        }

        private ModuleDescriptor parse(Path path, InputStream inputStream) throws IOException {
            JSONObject jsonObject = new JSONObject(new JSONTokener(new InputStreamReader(inputStream, "UTF-8")));
            JSONObject propertiesJSONObj = null;
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            ArrayList<String> propertiesFileReferences = new ArrayList<String>();
            if (jsonObject.has("properties")) {
                propertiesJSONObj = jsonObject.getJSONObject("properties");
                for (Object p : propertiesJSONObj.keySet()) {
                    String key = p.toString();
                    if ("@files".equals(key)) {
                        JSONArray propertyFiles = propertiesJSONObj.getJSONArray(key);
                        for (int i = 0; i < propertyFiles.length(); ++i) {
                            propertiesFileReferences.add(propertyFiles.getString(i));
                        }
                        continue;
                    }
                    properties.put(key, propertiesJSONObj.getString(key));
                }
            }
            GAV parent = null;
            if (jsonObject.has("parent")) {
                parent = GAV.parse(jsonObject.getString("parent"));
            }
            GAV gav = GAV.parse(jsonObject.getString("module"));
            String packaging = jsonObject.has("packaging") ? jsonObject.getString("packaging") : "jar";
            LinkedHashMap<String, List<ModuleDependency>> dependencies = new LinkedHashMap<String, List<ModuleDependency>>();
            if (jsonObject.has("dependencies")) {
                JSONObject scopes = jsonObject.getJSONObject("dependencies");
                for (Object s : scopes.keySet()) {
                    String scope = s.toString();
                    ArrayList<ModuleDependency> scopeDeps = new ArrayList<ModuleDependency>();
                    dependencies.put(scope, scopeDeps);
                    JSONArray deps = scopes.getJSONArray(scope);
                    for (int i = 0; i < deps.length(); ++i) {
                        scopeDeps.add(new ModuleDependency(GAV.parse(deps.getString(i))));
                    }
                }
            }
            LinkedHashMap<String, List<ModuleFragment>> fragments = new LinkedHashMap<String, List<ModuleFragment>>();
            if (jsonObject.has("fragments")) {
                JSONObject jsonFragments = jsonObject.getJSONObject("fragments");
                for (Object key : jsonFragments.keySet()) {
                    String type = (String)key;
                    ArrayList<ModuleFragment> fragmentsForType = new ArrayList<ModuleFragment>();
                    JSONArray array = jsonFragments.getJSONArray(type);
                    for (int i = 0; i < array.length(); ++i) {
                        String url = array.getString(i);
                        fragmentsForType.add(new ModuleFragment(url));
                    }
                    fragments.put(type, fragmentsForType);
                }
            }
            ModuleDescriptor parsedModuleDescriptor = new ModuleDescriptor(parent, gav, packaging, properties, propertiesFileReferences, fragments, dependencies, null);
            LinkedHashMap<String, String> interpolatedProperties = new LinkedHashMap<String, String>();
            if (propertiesJSONObj != null) {
                this.loadJsonProperties(path == null ? null : path.getParent(), interpolatedProperties, propertiesJSONObj);
            }
            GAV interpolatedParent = parent == null ? null : GAV.parse(RestxBuildHelper.expandProperties(interpolatedProperties, parent.toParseableString()));
            GAV interpolatedGAV = GAV.parse(RestxBuildHelper.expandProperties(interpolatedProperties, gav.toParseableString()));
            LinkedHashMap<String, List<ModuleDependency>> interpolatedDependencies = new LinkedHashMap<String, List<ModuleDependency>>();
            for (Map.Entry scopedDependenciesEntry : dependencies.entrySet()) {
                ArrayList<ModuleDependency> scopedDependencies = new ArrayList<ModuleDependency>();
                for (ModuleDependency dep : (List)scopedDependenciesEntry.getValue()) {
                    scopedDependencies.add(new ModuleDependency(GAV.parse(RestxBuildHelper.expandProperties(interpolatedProperties, dep.getGav().toParseableString()))));
                }
                interpolatedDependencies.put((String)scopedDependenciesEntry.getKey(), (List<ModuleDependency>)scopedDependencies);
            }
            LinkedHashMap<String, List<ModuleFragment>> interpolatedFragmentsPerModuleType = new LinkedHashMap<String, List<ModuleFragment>>();
            for (Map.Entry perModuleTypeFragment : fragments.entrySet()) {
                ArrayList<ModuleFragment> interpolatedFragments = new ArrayList<ModuleFragment>();
                for (ModuleFragment fragment : (List)perModuleTypeFragment.getValue()) {
                    interpolatedFragments.add(new ModuleFragment(RestxBuildHelper.expandProperties(interpolatedProperties, fragment.getUrl())));
                }
                interpolatedFragmentsPerModuleType.put((String)perModuleTypeFragment.getKey(), (List<ModuleFragment>)interpolatedFragments);
            }
            return new ModuleDescriptor(interpolatedParent, interpolatedGAV, packaging, interpolatedProperties, propertiesFileReferences, interpolatedFragmentsPerModuleType, interpolatedDependencies, parsedModuleDescriptor);
        }

        private void loadJsonProperties(Path path, Map<String, String> properties, JSONObject props) throws IOException {
            for (Object p : props.keySet()) {
                String key = p.toString();
                if (key.equals("@files")) {
                    JSONArray propertyFiles = props.getJSONArray(key);
                    for (int i = 0; i < propertyFiles.length(); ++i) {
                        Path propertyFilePath;
                        String propertyFile = propertyFiles.getString(i);
                        Path path2 = propertyFilePath = path == null ? Paths.get(propertyFile, new String[0]) : path.resolve(propertyFile);
                        if (!propertyFilePath.toFile().exists()) {
                            throw new IllegalArgumentException("can't resolve property file " + propertyFilePath.toAbsolutePath() + "." + " Not found." + (path == null ? " Note that parsing from mere inputstream resolve files relative to current directory." : ""));
                        }
                        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(propertyFilePath, new OpenOption[0]));){
                            this.loadJsonProperties(propertyFilePath.getParent(), properties, new JSONObject(new JSONTokener(reader)));
                            continue;
                        }
                    }
                    continue;
                }
                properties.put(key, props.getString(key));
            }
        }
    }

    static class Generator {
        Generator() {
        }

        public void generate(ModuleDescriptor md, Writer w) throws IOException {
            w.write("{\n");
            if (md.getParent() != null) {
                w.write(String.format("    \"parent\": \"%s\",\n", md.getParent().toParseableString()));
            }
            w.write(String.format("    \"module\": \"%s\",\n", md.getGav().toString()));
            if (!"jar".equals(md.getPackaging())) {
                w.write(String.format("    \"packaging\": \"%s\",\n", md.getPackaging()));
            }
            w.write("\n");
            w.write("    \"properties\": {\n");
            Iterator<Map.Entry<String, String>> iterator = md.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                w.write(String.format("        \"%s\": \"%s\"", entry.getKey(), entry.getValue()));
                if (iterator.hasNext() || !md.getPropertiesFileReferences().isEmpty()) {
                    w.write(",");
                }
                w.write("\n");
            }
            if (!md.getPropertiesFileReferences().isEmpty()) {
                w.write("      \"@files\": [\n");
                Iterator<String> itFileRef = md.getPropertiesFileReferences().iterator();
                while (itFileRef.hasNext()) {
                    w.write(String.format("        \"%s\"", itFileRef.next()));
                    if (itFileRef.hasNext()) {
                        w.write(",");
                    }
                    w.write("\n");
                }
                w.write("        ]\n");
            }
            w.write("    },\n\n");
            if (!md.getFragmentTypes().isEmpty()) {
                w.write("    \"fragments\": {\n");
                Iterator<String> itFragmentType = md.getFragmentTypes().iterator();
                while (itFragmentType.hasNext()) {
                    String fragmentType = itFragmentType.next();
                    w.write(String.format("      \"%s\": [\n", fragmentType));
                    Iterator<ModuleFragment> itFragment = md.getFragments(fragmentType).iterator();
                    while (itFragment.hasNext()) {
                        w.write(String.format("        \"%s\"", itFragment.next().getUrl()));
                        if (itFragment.hasNext()) {
                            w.write(",");
                        }
                        w.write("\n");
                    }
                    w.write("      ]");
                    if (itFragmentType.hasNext()) {
                        w.write(",");
                    }
                    w.write("\n");
                }
                w.write("    },\n\n");
            }
            w.write("    \"dependencies\": {\n");
            Set<String> scopes = md.getDependencyScopes();
            Iterator<String> itScopes = scopes.iterator();
            while (itScopes.hasNext()) {
                String scope = itScopes.next();
                w.write(String.format("        \"%s\": [\n", scope));
                Iterator<ModuleDependency> itDeps = md.getDependencies(scope).iterator();
                while (itDeps.hasNext()) {
                    ModuleDependency dependency = itDeps.next();
                    w.write(String.format("            \"%s\"", dependency.getGav().toParseableString()));
                    if (itDeps.hasNext()) {
                        w.write(",");
                    }
                    w.write("\n");
                }
                w.write("        ]");
                if (itScopes.hasNext()) {
                    w.write(",");
                }
                w.write("\n");
            }
            w.write("    }\n");
            w.write("}\n");
        }
    }
}

