/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.regex.Pattern;
import restx.build.ModuleDescriptor;
import restx.build.RestxBuildHelper;

public class ModuleFragment {
    private final String url;
    private boolean lazyContentLoaded = false;
    private String lazyContent = null;

    public ModuleFragment(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void write(ModuleDescriptor md, Writer w) throws IOException {
        String content = this.getLazilyContent();
        if (content != null) {
            w.write(content);
        }
    }

    public boolean resolvedContent() {
        try {
            String content = this.getLazilyContent();
            return content != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean matches(Pattern pattern) throws IOException {
        String content = this.getLazilyContent();
        return pattern.matcher(content).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLazilyContent() throws IOException {
        block30: {
            if (!this.lazyContentLoaded) {
                try {
                    if (this.url.startsWith("classpath://")) {
                        String fragmentPath = this.url.substring("classpath://".length());
                        try (InputStream stream = this.getClass().getResourceAsStream(fragmentPath);){
                            if (stream == null) {
                                throw new IllegalArgumentException("classpath fragment not found: '" + fragmentPath + "'" + ". Check your classpath.");
                            }
                            this.lazyContent = RestxBuildHelper.toString(stream);
                            break block30;
                        }
                    }
                    URL fragmentUrl = new URL(this.url);
                    try (InputStream stream = fragmentUrl.openStream();){
                        this.lazyContent = RestxBuildHelper.toString(stream);
                    }
                }
                finally {
                    this.lazyContentLoaded = true;
                }
            }
        }
        return this.lazyContent;
    }
}

