/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import restx.build.GAV;
import restx.build.ModuleDependency;
import restx.build.ModuleDescriptor;
import restx.build.ModuleFragment;
import restx.build.RestxBuild;
import restx.build.RestxBuildHelper;
import restx.build.org.json.JSONArray;
import restx.build.org.json.JSONObject;
import restx.build.org.json.JSONTokener;

public class RestxJsonSupport
implements RestxBuild.Parser,
RestxBuild.Generator {
    private final Generator generator = new Generator();
    private final Parser parser = new Parser();

    @Override
    public void generate(ModuleDescriptor md, Writer w) throws IOException {
        this.generator.generate(md, w);
    }

    @Override
    public ModuleDescriptor parse(InputStream inputStream) throws IOException {
        return this.parser.parse(inputStream);
    }

    @Override
    public ModuleDescriptor parse(Path path) throws IOException {
        return this.parser.parse(path);
    }

    @Override
    public String getDefaultFileName() {
        return "md.restx.json";
    }

    static class Parser {
        Parser() {
        }

        public ModuleDescriptor parse(Path path) throws IOException {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                ModuleDescriptor moduleDescriptor = this.parse(path, inputStream);
                return moduleDescriptor;
            }
        }

        public ModuleDescriptor parse(InputStream inputStream) throws IOException {
            return this.parse(null, inputStream);
        }

        private ModuleDescriptor parse(Path path, InputStream inputStream) throws IOException {
            JSONObject jsonObject = new JSONObject(new JSONTokener(new InputStreamReader(inputStream, "UTF-8")));
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            if (jsonObject.has("properties")) {
                this.loadJsonProperties(path == null ? null : path.getParent(), properties, jsonObject.getJSONObject("properties"));
            }
            GAV parent = null;
            if (jsonObject.has("parent")) {
                parent = GAV.parse(RestxBuildHelper.expandProperties(properties, jsonObject.getString("parent")));
            }
            GAV gav = GAV.parse(RestxBuildHelper.expandProperties(properties, jsonObject.getString("module")));
            String packaging = jsonObject.has("packaging") ? jsonObject.getString("packaging") : "jar";
            LinkedHashMap<String, List<ModuleDependency>> dependencies = new LinkedHashMap<String, List<ModuleDependency>>();
            if (jsonObject.has("dependencies")) {
                JSONObject scopes = jsonObject.getJSONObject("dependencies");
                for (Object s : scopes.keySet()) {
                    String scope = s.toString();
                    ArrayList<ModuleDependency> scopeDeps = new ArrayList<ModuleDependency>();
                    dependencies.put(scope, scopeDeps);
                    JSONArray deps = scopes.getJSONArray(scope);
                    for (int i = 0; i < deps.length(); ++i) {
                        scopeDeps.add(new ModuleDependency(GAV.parse(deps.getString(i))));
                    }
                }
            }
            LinkedHashMap<String, List<ModuleFragment>> fragments = new LinkedHashMap<String, List<ModuleFragment>>();
            if (jsonObject.has("fragments")) {
                JSONObject jsonFragments = jsonObject.getJSONObject("fragments");
                for (Object key : jsonFragments.keySet()) {
                    String type = (String)key;
                    ArrayList<ModuleFragment> fragmentsForType = new ArrayList<ModuleFragment>();
                    JSONArray array = jsonFragments.getJSONArray(type);
                    for (int i = 0; i < array.length(); ++i) {
                        InputStream stream;
                        String url = RestxBuildHelper.expandProperties(properties, array.getString(i));
                        if (url.startsWith("classpath://")) {
                            String fragmentPath = url.substring("classpath://".length());
                            stream = this.getClass().getResourceAsStream(fragmentPath);
                            if (stream == null) {
                                throw new IllegalArgumentException("classpath fragment not found: '" + fragmentPath + "'" + ". Check your classpath.");
                            }
                            fragmentsForType.add(new ModuleFragment(RestxBuildHelper.toString(stream)));
                            continue;
                        }
                        URL fragmentUrl = new URL(url);
                        stream = fragmentUrl.openStream();
                        Throwable throwable = null;
                        try {
                            fragmentsForType.add(new ModuleFragment(RestxBuildHelper.toString(stream)));
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                        }
                    }
                    fragments.put(type, fragmentsForType);
                }
            }
            return new ModuleDescriptor(parent, gav, packaging, properties, fragments, dependencies);
        }

        private void loadJsonProperties(Path path, Map<String, String> properties, JSONObject props) throws IOException {
            for (Object p : props.keySet()) {
                String key = p.toString();
                if (key.equals("@files")) {
                    JSONArray propertyFiles = props.getJSONArray(key);
                    for (int i = 0; i < propertyFiles.length(); ++i) {
                        Path propertyFilePath;
                        String propertyFile = propertyFiles.getString(i);
                        Path path2 = propertyFilePath = path == null ? Paths.get(propertyFile, new String[0]) : path.resolve(propertyFile);
                        if (!propertyFilePath.toFile().exists()) {
                            throw new IllegalArgumentException("can't resolve property file " + propertyFilePath.toAbsolutePath() + "." + " Not found." + (path == null ? " Note that parsing from mere inputstream resolve files relative to current directory." : ""));
                        }
                        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(propertyFilePath, new OpenOption[0]));){
                            this.loadJsonProperties(propertyFilePath.getParent(), properties, new JSONObject(new JSONTokener(reader)));
                            continue;
                        }
                    }
                    continue;
                }
                properties.put(key, props.getString(key));
            }
        }
    }

    static class Generator {
        Generator() {
        }

        public void generate(ModuleDescriptor md, Writer w) throws IOException {
            w.write("{\n");
            if (md.getParent() != null) {
                w.write(String.format("    \"parent\": \"%s\",\n", md.getParent()));
            }
            w.write(String.format("    \"module\": \"%s\",\n", md.getGav()));
            if (!"jar".equals(md.getPackaging())) {
                w.write(String.format("    \"packaging\": \"%s\",\n", md.getPackaging()));
            }
            w.write("\n");
            w.write("    \"properties\": {\n");
            Iterator<Map.Entry<String, String>> iterator = md.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                w.write(String.format("        \"%s\": \"%s\"", entry.getKey(), entry.getValue()));
                if (iterator.hasNext()) {
                    w.write(",");
                }
                w.write("\n");
            }
            w.write("    },\n\n");
            w.write("    \"dependencies\": {\n");
            Set<String> scopes = md.getDependencyScopes();
            Iterator<String> itScopes = scopes.iterator();
            while (itScopes.hasNext()) {
                String scope = itScopes.next();
                w.write(String.format("        \"%s\": [\n", scope));
                Iterator<ModuleDependency> itDeps = md.getDependencies(scope).iterator();
                while (itDeps.hasNext()) {
                    ModuleDependency dependency = itDeps.next();
                    w.write(String.format("            \"%s\"", dependency.getGav()));
                    if (itDeps.hasNext()) {
                        w.write(",");
                    }
                    w.write("\n");
                }
                w.write("        ]");
                if (itScopes.hasNext()) {
                    w.write(",");
                }
                w.write("\n");
            }
            w.write("    }\n");
            w.write("}\n");
        }
    }
}

