/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

public class GAV {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;

    public static GAV parse(String gav) {
        String[] parts = gav.split(":");
        if (parts.length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("can't parse '" + gav + "' as a module coordinates (GAV). " + "It must have at least 3 parts separated by columns. (4th is optional and correspond to artifact type)");
        }
        if (parts.length == 3) {
            return new GAV(parts[0], parts[1], parts[2]);
        }
        return new GAV(parts[0], parts[1], parts[2], parts[3]);
    }

    public GAV(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public GAV(String groupId, String artifactId, String version, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        if (this.type == null) {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.type;
    }
}

