/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import restx.build.GAV;
import restx.build.ModuleDependency;
import restx.build.ModuleDescriptor;
import restx.build.ModuleFragment;
import restx.build.RestxBuild;
import restx.build.RestxBuildHelper;
import restx.build.org.json.JSONArray;
import restx.build.org.json.JSONObject;
import restx.build.org.json.XML;

public class MavenSupport
implements RestxBuild.Parser,
RestxBuild.Generator {
    private final Parser parser = new Parser();
    private final Generator generator = new Generator();

    @Override
    public ModuleDescriptor parse(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            ModuleDescriptor moduleDescriptor = this.parse(inputStream);
            return moduleDescriptor;
        }
    }

    @Override
    public ModuleDescriptor parse(InputStream stream) throws IOException {
        return this.parser.parse(stream);
    }

    @Override
    public void generate(ModuleDescriptor md, Writer w) throws IOException {
        this.generator.generate(md, w);
    }

    @Override
    public String getDefaultFileName() {
        return "pom.xml";
    }

    static class Generator {
        private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n\n";
        private static final String FOOTER = "</project>\n";

        Generator() {
        }

        public void generate(ModuleDescriptor md, Writer w) throws IOException {
            w.write(HEADER);
            if (md.getParent() != null) {
                w.write("    <parent>\n");
                this.toMavenGAV(md.getParent(), "        ", w);
                w.write("    </parent>\n\n");
            }
            this.toMavenGAV(md.getGav(), "    ", w);
            this.writeXmlTag(w, "    ", "packaging", md.getPackaging());
            this.writeXmlTag(w, "    ", "name", md.getGav().getArtifactId());
            w.write("\n");
            w.write("    <properties>\n");
            for (Map.Entry<String, String> entry : md.getProperties().entrySet()) {
                if (entry.getKey().equals("java.version")) {
                    this.writeXmlTag(w, "        ", "maven.compiler.target", entry.getValue());
                    this.writeXmlTag(w, "        ", "maven.compiler.source", entry.getValue());
                    continue;
                }
                if (entry.getKey().endsWith(".version")) {
                    if (!this.isVersionPropertyUsed(md, entry.getKey())) continue;
                    this.writeXmlTag(w, "        ", entry.getKey(), entry.getValue());
                    continue;
                }
                this.writeXmlTag(w, "        ", entry.getKey(), entry.getValue());
            }
            w.write("    </properties>\n\n");
            w.write("    <dependencies>\n");
            for (String scope : md.getDependencyScopes()) {
                for (ModuleDependency dependency : md.getDependencies(scope)) {
                    w.write("        <dependency>\n");
                    this.toMavenGAV(dependency.getGav(), "            ", w);
                    if (!"compile".equals(scope)) {
                        this.writeXmlTag(w, "            ", "scope", scope);
                    }
                    w.write("        </dependency>\n");
                }
            }
            w.write("    </dependencies>\n");
            for (ModuleFragment fragment : md.getFragments("maven")) {
                fragment.write(md, w);
            }
            w.write(FOOTER);
        }

        private boolean isVersionPropertyUsed(ModuleDescriptor md, String property) {
            for (String scope : md.getDependencyScopes()) {
                for (ModuleDependency dependency : md.getDependencies(scope)) {
                    if (dependency.getGav().getVersion().indexOf("${" + property + "}") == -1) continue;
                    return true;
                }
            }
            return false;
        }

        private void toMavenGAV(GAV gav, String indent, Writer w) throws IOException {
            this.writeXmlTag(w, indent, "groupId", gav.getGroupId());
            this.writeXmlTag(w, indent, "artifactId", gav.getArtifactId());
            this.writeXmlTag(w, indent, "version", gav.getVersion());
        }

        private void writeXmlTag(Writer w, String indent, String tag, String val) throws IOException {
            w.write(indent);
            w.write("<");
            w.write(tag);
            w.write(">");
            w.write(val);
            w.write("</");
            w.write(tag);
            w.write(">\n");
        }
    }

    static class Parser {
        Parser() {
        }

        public ModuleDescriptor parse(InputStream stream) throws IOException {
            GAV parent;
            JSONObject jsonObject = XML.toJSONObject(RestxBuildHelper.toString(stream)).getJSONObject("project");
            if (jsonObject.has("parent")) {
                JSONObject parentObject = jsonObject.getJSONObject("parent");
                parent = this.getGav(parentObject);
            } else {
                parent = null;
            }
            GAV gav = this.getGav(jsonObject);
            String packaging = jsonObject.has("packaging") ? jsonObject.getString("packaging") : "jar";
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            if (jsonObject.has("properties")) {
                JSONObject props = jsonObject.getJSONObject("properties");
                for (Object o : props.keySet()) {
                    String p = (String)o;
                    if (p.equals("maven.compiler.target") || p.equals("maven.compiler.source")) {
                        properties.put("java.version", String.valueOf(props.get(p)));
                        continue;
                    }
                    properties.put(p, String.valueOf(props.get(p)));
                }
            }
            LinkedHashMap<String, List<ModuleDependency>> dependencies = new LinkedHashMap<String, List<ModuleDependency>>();
            if (jsonObject.has("dependencies")) {
                JSONArray deps = jsonObject.getJSONObject("dependencies").getJSONArray("dependency");
                for (int i = 0; i < deps.length(); ++i) {
                    JSONObject dep = deps.getJSONObject(i);
                    String scope = dep.has("scope") ? dep.getString("scope") : "compile";
                    ArrayList<ModuleDependency> scopeDependencies = (ArrayList<ModuleDependency>)dependencies.get(scope);
                    if (scopeDependencies == null) {
                        scopeDependencies = new ArrayList<ModuleDependency>();
                        dependencies.put(scope, scopeDependencies);
                    }
                    scopeDependencies.add(new ModuleDependency(this.getGav(dep)));
                }
            }
            return new ModuleDescriptor(parent, gav, packaging, properties, new HashMap<String, List<ModuleFragment>>(), dependencies);
        }

        private GAV getGav(JSONObject jsonObject) {
            return new GAV(jsonObject.getString("groupId"), jsonObject.getString("artifactId"), String.valueOf(jsonObject.get("version")));
        }
    }
}

