/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

public class GAV {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public static GAV parse(String gav) {
        String[] parts = gav.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("can't parse '" + gav + "' as a module coordinates (GAV). " + "It must have exactly 3 parts separated by columns.");
        }
        return new GAV(parts[0], parts[1], parts[2]);
    }

    public GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }
}

