/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import restx.build.IvySupport;
import restx.build.MavenSupport;
import restx.build.ModuleDescriptor;
import restx.build.RestxJsonSupport;

public class RestxBuild {
    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        if (args.length != 3 || !args[0].equalsIgnoreCase("convert")) {
            out.println("usage: restx-build convert <from> <to>\n\teg: restx-build convert md.restx.json pom.xml\n\nyou can also use **/ syntax to convert a bunch of files:\t    restx-build convert **/md.restx.json module.ivy");
            System.exit(1);
        }
        RestxBuild.convert(args[1], args[2]);
        out.println("conversion done.");
    }

    public static List<Path> convert(String from, final String to) throws IOException {
        final ArrayList<Path> converted = new ArrayList<Path>();
        int idx = from.indexOf("**/");
        if (idx != -1) {
            Path startFrom = Paths.get(from.substring(0, idx), new String[0]);
            final String name = from.substring(idx + "**/".length());
            Files.walkFileTree(startFrom, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile() && file.endsWith(name)) {
                        RestxBuild.convert(file, file.getParent().resolve(to));
                        converted.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Path fromPath = Paths.get(from, new String[0]);
            Path toPath = Paths.get(to, new String[0]);
            RestxBuild.convert(fromPath, toPath);
            converted.add(fromPath);
        }
        return converted;
    }

    public static void convert(Path fromPath, Path toPath) throws IOException {
        Parser parser = RestxBuild.guessParserFor(fromPath);
        Generator generator = RestxBuild.guessGeneratorFor(toPath);
        try (FileWriter writer = new FileWriter(toPath.toFile());){
            ModuleDescriptor md = parser.parse(fromPath);
            generator.generate(md, writer);
        }
    }

    private static Generator guessGeneratorFor(Path path) {
        if (path.toString().endsWith(".ivy") || path.endsWith("ivy.xml")) {
            return new IvySupport();
        }
        if (path.endsWith("pom.xml")) {
            return new MavenSupport();
        }
        return new RestxJsonSupport();
    }

    private static Parser guessParserFor(Path path) {
        if (path.endsWith("pom.xml")) {
            return new MavenSupport();
        }
        return new RestxJsonSupport();
    }

    public static interface Generator {
        public void generate(ModuleDescriptor var1, Writer var2) throws IOException;

        public String getDefaultFileName();
    }

    public static interface Parser {
        public ModuleDescriptor parse(Path var1) throws IOException;

        public ModuleDescriptor parse(InputStream var1) throws IOException;
    }
}

