/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.utils.test.testcontainers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class ZookeeperContainer
extends GenericContainer<ZookeeperContainer> {
    public static final String DEFAULT_IMAGE = "zookeeper";
    public static final String DEFAULT_TAG = "3.5";
    public static final int CONNECT_PORT = 2181;
    public static final int ADMIN_PORT = 8080;
    private static final String[] FOUR_LETTER_COMMANDS = new String[]{"srvr", "stat", "wchc", "dump", "crst", "srst", "envi", "conf", "telnet close", "wchs", "wchp", "dirs", "cons", "mntr", "isro", "ruok", "gtmk", "stmk"};

    public ZookeeperContainer() {
        this("zookeeper:3.5");
    }

    public ZookeeperContainer(String dockerImageName) {
        super(dockerImageName);
        this.waitStrategy = Wait.forLogMessage((String)".*binding to port .*:2181\n", (int)1);
        this.addExposedPorts(new int[]{2181, 8080});
        this.addEnv("ZOO_4LW_COMMANDS_WHITELIST", String.join((CharSequence)",", FOUR_LETTER_COMMANDS));
    }

    public String getZkConnect() {
        return String.format("%s:%d", this.getContainerIpAddress(), this.getMappedPort(2181));
    }

    public String getAdminUrl() {
        return String.format("http://%s:%d/commands", this.getContainerIpAddress(), this.getMappedPort(8080));
    }
}

