/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.utils.test.testcontainers;

import io.redlink.utils.PathUtils;
import io.redlink.utils.ResourceLoaderUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class SolrContainer
extends FailureDetectingExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(SolrContainer.class);
    private static final String DEFAULT_IMAGE = "solr";
    private static final String DEFAULT_TAG = "7.7.1";
    private static final Integer SOLR_PORT = 8983;
    private final TemporaryFolder temporaryFolder;
    private final GenericContainer<?> container;
    private final String coreName;
    private final String confDir;
    private final Duration startupTimeout;

    private SolrContainer(String image, String coreName, String confDir, File workingDir, Duration startupTimeout) {
        this.coreName = coreName;
        this.confDir = confDir;
        Assert.assertTrue((String)"workingDir does not exist", (boolean)workingDir.exists());
        Assert.assertTrue((String)"workingDir not a directory", (boolean)workingDir.isDirectory());
        this.container = new GenericContainer(image);
        this.temporaryFolder = new TemporaryFolder(workingDir);
        this.startupTimeout = startupTimeout == null ? Duration.ofSeconds(15L) : startupTimeout;
    }

    protected void starting(Description description) {
        super.starting(description);
        try {
            this.before();
        }
        catch (Exception t) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Failed to initialize SolrContainer(coreName: {} |\u00a0confDir: {} | tmpFolder: {})", new Object[]{this.coreName, this.confDir, this.temporaryFolder, t});
            } else {
                LOG.error("Failed to initialize SolrContainer(coreName: {} |\u00a0confDir: {} | tmpFolder: {} |\u00a0{} - {})", new Object[]{this.coreName, this.confDir, this.temporaryFolder, t.getClass().getSimpleName(), t.getMessage()});
            }
            Assert.fail((String)("Failed to initialize (" + t.getClass().getSimpleName() + " - " + t.getMessage() + ")"));
        }
    }

    protected void before() throws IOException {
        this.temporaryFolder.create();
        File mountableConf = this.temporaryFolder.newFolder(this.coreName);
        Path source = ResourceLoaderUtils.getResourceAsPath((String)this.confDir, ((Object)((Object)this)).getClass());
        PathUtils.copyRecursive((Path)source, (Path)mountableConf.toPath());
        this.container.addExposedPort(SOLR_PORT);
        this.container.withFileSystemBind(mountableConf.getAbsolutePath(), "/core-conf", BindMode.READ_ONLY);
        this.container.withCommand(new String[]{"solr-precreate", this.coreName, "/core-conf"});
        this.container.waitingFor(Wait.forLogMessage((String)(".*SolrCore \\Q[" + this.coreName + "]\\E Registered new searcher.*\n"), (int)1).withStartupTimeout(this.startupTimeout));
        this.container.start();
    }

    protected void finished(Description description) {
        super.finished(description);
        this.after();
    }

    protected void after() {
        this.container.stop();
        this.temporaryFolder.delete();
    }

    public String getCoreName() {
        return this.coreName;
    }

    public String getSolrUrl() {
        return String.format("http://%s:%d/solr", this.container.getContainerIpAddress(), this.container.getMappedPort(SOLR_PORT.intValue()));
    }

    public String getCoreUrl() {
        return String.format("%s/%s", this.getSolrUrl(), this.coreName);
    }

    public static SolrContainer create(String confDir) {
        return SolrContainer.create("collection", confDir);
    }

    public static SolrContainer create(String confDir, Duration startupTimeout) {
        return SolrContainer.create("collection", confDir, startupTimeout);
    }

    public static SolrContainer create(String collectionName, String confDir) {
        return SolrContainer.create("solr:7.7.1", collectionName, confDir);
    }

    public static SolrContainer create(String collectionName, String confDir, Duration startupTimeout) {
        return SolrContainer.create("solr:7.7.1", collectionName, confDir, startupTimeout);
    }

    public static SolrContainer create(String image, String collectionName, String confDir) {
        return SolrContainer.create(image, collectionName, confDir, new File("."));
    }

    public static SolrContainer create(String image, String collectionName, String confDir, Duration startupTimeout) {
        return SolrContainer.create(image, collectionName, confDir, new File("."), startupTimeout);
    }

    public static SolrContainer create(String image, String collectionName, String confDir, File workingDir) {
        return SolrContainer.create(image, collectionName, confDir, workingDir, null);
    }

    public static SolrContainer create(String image, String collectionName, String confDir, File workingDir, Duration startupTimeout) {
        return new SolrContainer(image, collectionName, confDir, workingDir, startupTimeout);
    }
}

