/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.utils.test.testcontainers;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class VindContainer
extends FailureDetectingExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(VindContainer.class);
    public static final String DEFAULT_IMAGE = "redlinkgmbh/vind-solr-server";
    public static final String DEFAULT_TAG = "latest";
    public static final String VIND_CORE_NAME = "vind";
    public static final Integer SOLR_PORT = 8983;
    private final GenericContainer<?> container;
    private final Duration startupTimeout;
    private final Set<String> coreNames;

    private VindContainer(String image, Collection<String> coreNames, Duration startupTimeout) {
        this.container = new GenericContainer(image);
        this.coreNames = new HashSet<String>(coreNames);
        this.startupTimeout = startupTimeout == null ? Duration.ofSeconds(15L) : startupTimeout;
    }

    protected void starting(Description description) {
        super.starting(description);
        try {
            this.before();
        }
        catch (Exception t) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Failed to initialize VindContainer", (Throwable)t);
            } else {
                LOG.error("Failed to initialize VindContainer({} - {})", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
            }
            Assert.fail((String)("Failed to initialize (" + t.getClass().getSimpleName() + " - " + t.getMessage() + ")"));
        }
    }

    protected void before() {
        this.container.addExposedPort(SOLR_PORT);
        this.container.addEnv("CORES", String.join((CharSequence)",", this.coreNames));
        String coreNamesRegex = this.coreNames.stream().map(Pattern::quote).collect(Collectors.joining("|", "(", ")"));
        this.container.waitingFor(Wait.forLogMessage((String)(".*SolrCore \\Q[\\E" + coreNamesRegex + "\\Q]\\E Registered new searcher.*\n"), (int)this.coreNames.size()).withStartupTimeout(this.startupTimeout));
        this.container.start();
    }

    protected void finished(Description description) {
        super.finished(description);
        this.after();
    }

    protected void after() {
        this.container.stop();
    }

    public Set<String> getCoreNames() {
        return Collections.unmodifiableSet(this.coreNames);
    }

    public String getSolrUrl() {
        return String.format("http://%s:%d/solr", this.container.getContainerIpAddress(), this.container.getMappedPort(SOLR_PORT.intValue()));
    }

    public String getCoreUrl(String coreName) {
        return String.format("%s/%s", this.getSolrUrl(), coreName);
    }

    public String getVindUrl() {
        return this.getCoreUrl(VIND_CORE_NAME);
    }

    public static VindContainer create() {
        return VindContainer.create(null, Collections.emptySet());
    }

    public static VindContainer create(Duration startupTimeout) {
        return VindContainer.create(startupTimeout, Collections.emptySet());
    }

    public static VindContainer create(Collection<String> collectionNames) {
        return VindContainer.create("redlinkgmbh/vind-solr-server:latest", null, collectionNames);
    }

    public static VindContainer create(Duration startupTimeout, Collection<String> collectionNames) {
        return VindContainer.create("redlinkgmbh/vind-solr-server:latest", startupTimeout, collectionNames);
    }

    public static VindContainer create(String image, Duration startupTimeout) {
        return VindContainer.create(image, startupTimeout, Collections.emptySet());
    }

    public static VindContainer create(String image, String collectionName) {
        return VindContainer.create(image, null, collectionName);
    }

    public static VindContainer create(String image, Duration startupTimeout, String collectionName) {
        return VindContainer.create(image, startupTimeout, Collections.singleton(collectionName));
    }

    public static VindContainer create(String image, Duration startupTimeout, Collection<String> collectionNames) {
        HashSet<String> collections = new HashSet<String>();
        collections.add(VIND_CORE_NAME);
        collections.addAll(collectionNames);
        return new VindContainer(image, collections, startupTimeout);
    }
}

