/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.utils.test.testcontainers;

import java.util.Objects;
import java.util.concurrent.Future;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;

public class MongoContainer
extends GenericContainer<MongoContainer> {
    private static final String DEFAULT_IMAGE = "mongo";
    private static final String DEFAULT_TAG = "3.6";
    private static final Integer MONGO_PORT = 27017;
    private String databaseName = null;

    public MongoContainer() {
        this("mongo:3.6");
    }

    public MongoContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public MongoContainer(Future<String> image) {
        super(image);
    }

    protected void configure() {
        super.configure();
        this.addExposedPort(MONGO_PORT);
    }

    public MongoContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (MongoContainer)this.self();
    }

    protected WaitStrategy getWaitStrategy() {
        return Wait.forLogMessage((String)".*waiting for connections on port.*\n", (int)1);
    }

    public String getConnectionUrl() {
        return "mongodb://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MONGO_PORT) + StringUtils.defaultString((String)MongoContainer.prependIfNotBlank(this.databaseName, "/"));
    }

    private static String prependIfNotBlank(String value, String prepend) {
        if (StringUtils.isNotBlank((String)value)) {
            return prepend + value;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MongoContainer)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoContainer that = (MongoContainer)((Object)o);
        return Objects.equals(this.databaseName, that.databaseName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.databaseName);
    }
}

