/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib.standalone;

import com.google.common.base.Preconditions;
import io.redlink.solrlib.SolrCoreContainer;
import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.solrlib.standalone.SolrServerConnectorConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.common.util.NamedList;

public class SolrServerConnector
extends SolrCoreContainer {
    private final SolrServerConnectorConfiguration configuration;
    private final String prefix;
    private final String solrBaseUrl;
    private final AtomicBoolean initialized;

    public SolrServerConnector(Set<SolrCoreDescriptor> coreDescriptors, SolrServerConnectorConfiguration configuration) {
        this(coreDescriptors, configuration, null);
    }

    public SolrServerConnector(Set<SolrCoreDescriptor> coreDescriptors, SolrServerConnectorConfiguration configuration, ExecutorService executorService) {
        super(coreDescriptors, executorService);
        this.configuration = configuration;
        this.prefix = StringUtils.defaultString((String)configuration.getPrefix());
        this.solrBaseUrl = StringUtils.removeEnd((String)configuration.getSolrUrl(), (String)"/");
        this.initialized = new AtomicBoolean(false);
    }

    protected void init(ExecutorService executorService) throws IOException, SolrServerException {
        Preconditions.checkState((boolean)this.initialized.compareAndSet(false, true));
        Preconditions.checkArgument((boolean)Objects.nonNull(this.solrBaseUrl));
        if (this.configuration.isDeployCores() && Objects.nonNull(this.configuration.getSolrHome())) {
            Path solrHome = this.configuration.getSolrHome();
            Files.createDirectories(solrHome, new FileAttribute[0]);
            Path libDir = solrHome.resolve("lib");
            Files.createDirectories(libDir, new FileAttribute[0]);
            try (HttpSolrClient solrClient = new HttpSolrClient.Builder(this.solrBaseUrl).build();){
                for (SolrCoreDescriptor coreDescriptor : this.coreDescriptors) {
                    String coreName = coreDescriptor.getCoreName();
                    if (this.availableCores.containsKey(coreName)) {
                        this.log.warn("CoreName-Clash: {} already initialized. Skipping {}", (Object)coreName, coreDescriptor.getClass());
                        continue;
                    }
                    String remoteName = this.createRemoteName(coreName);
                    Path coreHome = solrHome.resolve(remoteName);
                    coreDescriptor.initCoreDirectory(coreHome, libDir);
                    Path corePropertiesFile = coreHome.resolve("core.properties");
                    Files.deleteIfExists(corePropertiesFile);
                    if (coreDescriptor.getNumShards() > 1 || coreDescriptor.getReplicationFactor() > 1) {
                        this.log.warn("Deploying {} to SolrServerConnector, ignoring config of shards={},replication={}", new Object[]{coreName, coreDescriptor.getNumShards(), coreDescriptor.getReplicationFactor()});
                    }
                    CoreAdminResponse coreAdminResponse = CoreAdminRequest.getStatus((String)remoteName, (SolrClient)solrClient).getStartTime(remoteName) == null ? CoreAdminRequest.createCore((String)remoteName, (String)coreHome.toAbsolutePath().toString(), (SolrClient)solrClient) : CoreAdminRequest.reloadCore((String)remoteName, (SolrClient)solrClient);
                    if (this.findInNamedList(CoreAdminRequest.getStatus((String)remoteName, (SolrClient)solrClient).getCoreStatus(remoteName), "index", "lastModified") == null) {
                        this.scheduleCoreInit(executorService, coreDescriptor, true);
                    } else {
                        this.scheduleCoreInit(executorService, coreDescriptor, false);
                    }
                    this.availableCores.put(coreName, coreDescriptor);
                }
            }
        }
        try (HttpSolrClient solrClient = new HttpSolrClient.Builder(this.solrBaseUrl).build();){
            for (SolrCoreDescriptor coreDescriptor : this.coreDescriptors) {
                String coreName = coreDescriptor.getCoreName();
                if (this.availableCores.containsKey(coreName)) {
                    this.log.warn("CoreName-Clash: {} already initialized. Skipping {}", (Object)coreName, coreDescriptor.getClass());
                    continue;
                }
                String remoteName = this.createRemoteName(coreName);
                if (CoreAdminRequest.getStatus((String)remoteName, (SolrClient)solrClient).getStartTime(remoteName) == null) {
                    this.log.warn("Collection {} (remote: {}) not available in Solr '{}' but deployCores is set to false", new Object[]{coreName, remoteName, this.solrBaseUrl});
                    continue;
                }
                this.log.debug("Collection {} exists in Solr '{}' as {}", new Object[]{coreName, this.solrBaseUrl, remoteName});
                this.scheduleCoreInit(executorService, coreDescriptor, false);
                this.availableCores.put(coreName, coreDescriptor);
            }
        }
    }

    private Object findInNamedList(NamedList namedList, String ... path) {
        NamedList nested;
        if (path.length < 1) {
            return null;
        }
        Object value = namedList.get(path[0]);
        if (path.length == 1) {
            return value;
        }
        NamedList namedList2 = nested = value instanceof NamedList ? (NamedList)value : null;
        if (nested != null) {
            return this.findInNamedList(nested, Arrays.copyOfRange(path, 1, path.length));
        }
        return null;
    }

    protected String createRemoteName(String coreName) {
        return this.prefix + coreName;
    }

    protected SolrClient createSolrClient(String coreName) {
        return new HttpSolrClient.Builder(this.solrBaseUrl + StringUtils.prependIfMissing((String)this.createRemoteName(coreName), (CharSequence)"/", (CharSequence[])new CharSequence[0])).build();
    }
}

