/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib.spring.boot.autoconfigure;

import io.redlink.solrlib.SolrCoreContainer;
import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibEmbeddedAutoconfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibProperties;
import io.redlink.solrlib.standalone.SolrServerConnector;
import io.redlink.solrlib.standalone.SolrServerConnectorConfiguration;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={SolrCoreContainer.class, SolrServerConnector.class})
@EnableConfigurationProperties(value={SolrLibProperties.class})
@AutoConfigureBefore(value={SolrLibEmbeddedAutoconfiguration.class})
public class SolrLibStandaloneAutoconfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrLibProperties props;
    private final Set<SolrCoreDescriptor> coreDescriptors;

    public SolrLibStandaloneAutoconfiguration(SolrLibProperties props, ObjectProvider<Set<SolrCoreDescriptor>> coreDescriptors) {
        this.props = props;
        this.coreDescriptors = (Set)ObjectUtils.defaultIfNull((Object)coreDescriptors.getIfAvailable(), Collections.emptySet());
    }

    @Primary
    @Bean(initMethod="initialize", destroyMethod="shutdown")
    @Scope(value="singleton")
    @ConditionalOnClass(value={SolrServerConnector.class})
    @ConditionalOnProperty(value={"solrlib.base-url"})
    @ConditionalOnMissingBean(value={SolrCoreContainer.class})
    public SolrCoreContainer solrServerConnector() {
        this.log.debug("Creating solrServerConnector");
        SolrServerConnectorConfiguration config = new SolrServerConnectorConfiguration();
        config.setSolrUrl(this.props.getBaseUrl());
        config.setSolrHome(this.props.getHome());
        config.setPrefix(this.props.getCollectionPrefix());
        config.setDeployCores(this.props.isDeployCores());
        return new SolrServerConnector(this.coreDescriptors, config);
    }
}

