/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib.spring.boot.autoconfigure;

import io.redlink.solrlib.SolrCoreContainer;
import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibCloudAutoconfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibEmbeddedAutoconfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibStandaloneAutoconfiguration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SolrLibEmbeddedAutoconfiguration.class, SolrLibStandaloneAutoconfiguration.class, SolrLibCloudAutoconfiguration.class})
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={SolrCoreContainer.class})
@ConditionalOnEnabledHealthIndicator(value="solrlib")
public class SolrLibHealthIndicatorConfiguration {
    private final SolrCoreContainer solrCoreContainer;
    private final Set<SolrCoreDescriptor> coreDescriptors;
    private final HealthAggregator healthAggregator;

    public SolrLibHealthIndicatorConfiguration(SolrCoreContainer solrCoreContainer, Optional<Set<SolrCoreDescriptor>> coreDescriptors, HealthAggregator healthAggregator) {
        this.solrCoreContainer = solrCoreContainer;
        this.coreDescriptors = coreDescriptors.orElseGet(Collections::emptySet);
        this.healthAggregator = healthAggregator;
    }

    @Bean
    public HealthIndicator solrlibHealthIndicator() {
        CompositeHealthIndicator healthIndicator = new CompositeHealthIndicator(this.healthAggregator);
        healthIndicator.addHealthIndicator("coreContainer", (HealthIndicator)new CoreContainerHealthIndicator(this.solrCoreContainer));
        CompositeHealthIndicator coreIndicator = new CompositeHealthIndicator(this.healthAggregator);
        for (SolrCoreDescriptor descriptor : this.coreDescriptors) {
            coreIndicator.addHealthIndicator(descriptor.getCoreName(), (HealthIndicator)new CoreDescriptorHealthIndicator(this.solrCoreContainer, descriptor));
        }
        healthIndicator.addHealthIndicator("collections", (HealthIndicator)coreIndicator);
        return healthIndicator;
    }

    public static class CoreDescriptorHealthIndicator
    extends AbstractHealthIndicator {
        private final SolrCoreContainer solrCoreContainer;
        private final SolrCoreDescriptor coreDescriptor;

        public CoreDescriptorHealthIndicator(SolrCoreContainer solrCoreContainer, SolrCoreDescriptor coreDescriptor) {
            this.solrCoreContainer = solrCoreContainer;
            this.coreDescriptor = coreDescriptor;
        }

        protected void doHealthCheck(Health.Builder builder) throws Exception {
            if (this.solrCoreContainer == null) {
                builder.unknown();
            } else if (!this.solrCoreContainer.isStartupComplete()) {
                builder.outOfService();
            } else {
                try (SolrClient solrClient = this.solrCoreContainer.getSolrClient(this.coreDescriptor);){
                    SolrPingResponse ping = solrClient.ping();
                    builder.up().withDetail("ping", (Object)ping.getQTime()).withDetail("response", ping.getResponse().get("status"));
                }
            }
        }
    }

    public static class CoreContainerHealthIndicator
    extends AbstractHealthIndicator {
        private final SolrCoreContainer solrCoreContainer;

        private CoreContainerHealthIndicator(SolrCoreContainer solrCoreContainer) {
            this.solrCoreContainer = solrCoreContainer;
        }

        protected void doHealthCheck(Health.Builder builder) throws Exception {
            if (this.solrCoreContainer == null) {
                builder.unknown();
                return;
            }
            if (!this.solrCoreContainer.isStartupComplete()) {
                builder.outOfService().withDetail("startup", (Object)"in-progress");
            } else {
                builder.up().withDetail("startup", (Object)"complete");
            }
            builder.withDetail("class", (Object)this.solrCoreContainer.getClass().getName());
        }
    }
}

