/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib.spring.boot.autoconfigure;

import io.redlink.solrlib.SolrCoreContainer;
import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.solrlib.embedded.EmbeddedCoreContainer;
import io.redlink.solrlib.embedded.EmbeddedCoreContainerConfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibCloudAutoconfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibProperties;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibStandaloneAutoconfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={SolrCoreContainer.class, EmbeddedCoreContainer.class})
@EnableConfigurationProperties(value={SolrLibProperties.class})
@AutoConfigureAfter(value={SolrLibCloudAutoconfiguration.class, SolrLibStandaloneAutoconfiguration.class})
public class SolrLibEmbeddedAutoconfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrLibProperties props;
    private final Set<SolrCoreDescriptor> coreDescriptors;

    public SolrLibEmbeddedAutoconfiguration(SolrLibProperties props, Optional<Set<SolrCoreDescriptor>> coreDescriptors) {
        this.props = props;
        this.coreDescriptors = coreDescriptors.orElseGet(Collections::emptySet);
    }

    @Bean(initMethod="initialize", destroyMethod="shutdown")
    @Scope(value="singleton")
    @ConditionalOnMissingBean(value={SolrCoreContainer.class})
    public SolrCoreContainer embeddedSolrCoreContainer() {
        this.log.debug("Creating embeddedSolrCoreContainer");
        EmbeddedCoreContainerConfiguration config = new EmbeddedCoreContainerConfiguration();
        Path solrHome = this.props.getHome();
        if (solrHome == null) {
            try {
                solrHome = Files.createTempDirectory("solrlib", new FileAttribute[0]);
                this.log.warn("No solrlib.home provided, creating tempdir {}", (Object)solrHome);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create temp-dir as solr home", e);
            }
        }
        config.setHome(solrHome);
        config.setDeleteOnShutdown(this.props.isDeleteOnShutdown());
        return new EmbeddedCoreContainer(this.coreDescriptors, config);
    }
}

