/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib.spring.boot.autoconfigure;

import io.redlink.solrlib.SolrCoreContainer;
import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.solrlib.cloud.SolrCloudConnector;
import io.redlink.solrlib.cloud.SolrCloudConnectorConfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibEmbeddedAutoconfiguration;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibProperties;
import io.redlink.solrlib.spring.boot.autoconfigure.SolrLibStandaloneAutoconfiguration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={SolrCoreContainer.class, SolrCloudConnector.class})
@EnableConfigurationProperties(value={SolrLibProperties.class})
@AutoConfigureBefore(value={SolrLibStandaloneAutoconfiguration.class, SolrLibEmbeddedAutoconfiguration.class})
public class SolrLibCloudAutoconfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrLibProperties props;
    private final Set<SolrCoreDescriptor> coreDescriptors;

    public SolrLibCloudAutoconfiguration(SolrLibProperties props, Optional<Set<SolrCoreDescriptor>> coreDescriptors) {
        this.props = props;
        this.coreDescriptors = coreDescriptors.orElseGet(Collections::emptySet);
    }

    @Primary
    @Bean(initMethod="initialize", destroyMethod="shutdown")
    @Scope(value="singleton")
    @ConditionalOnProperty(value={"solrlib.zk-connection"})
    @ConditionalOnMissingBean(value={SolrCoreContainer.class})
    public SolrCoreContainer solrCloudConnector() {
        this.log.debug("Creating solrCloudConnector");
        SolrCloudConnectorConfiguration config = new SolrCloudConnectorConfiguration();
        config.setZkConnection(this.props.getZkConnection());
        config.setMaxShardsPerNode(this.props.getMaxShardsPerNode());
        config.setPrefix(this.props.getCollectionPrefix());
        config.setDeployCores(this.props.isDeployCores());
        return new SolrCloudConnector(this.coreDescriptors, config);
    }
}

