/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib.cloud;

import io.redlink.solrlib.SolrCoreContainer;
import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.solrlib.cloud.SolrCloudConnectorConfiguration;
import io.redlink.utils.PathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.util.NamedList;

public class SolrCloudConnector
extends SolrCoreContainer {
    private final SolrCloudConnectorConfiguration config;
    private final String prefix;

    public SolrCloudConnector(Set<SolrCoreDescriptor> coreDescriptors, SolrCloudConnectorConfiguration configuration) {
        this(coreDescriptors, configuration, null);
    }

    public SolrCloudConnector(Set<SolrCoreDescriptor> coreDescriptors, SolrCloudConnectorConfiguration configuration, ExecutorService executorService) {
        super(coreDescriptors, executorService);
        this.config = configuration;
        this.prefix = StringUtils.defaultString((String)configuration.getPrefix());
    }

    protected void init(ExecutorService executorService) throws IOException, SolrServerException {
        Path sharedLibs = Files.createTempDirectory("solrSharedLibs", new FileAttribute[0]);
        try (CloudSolrClient client = this.createSolrClient();){
            NamedList list = client.request((SolrRequest)CollectionAdminRequest.listCollections());
            List existingCollections = (List)list.get("collections");
            for (SolrCoreDescriptor coreDescriptor : this.coreDescriptors) {
                String coreName = coreDescriptor.getCoreName();
                String remoteName = this.createRemoteName(coreName);
                if (this.availableCores.containsKey(coreName)) {
                    this.log.warn("CoreName-Clash: {} already initialized. Skipping {}", (Object)coreName, coreDescriptor.getClass());
                    continue;
                }
                this.log.info("Initializing Core {} (remote: {})", (Object)coreName, (Object)remoteName);
                if (this.config.isDeployCores()) {
                    Path tmp = Files.createTempDirectory(coreName, new FileAttribute[0]);
                    try {
                        NamedList response;
                        coreDescriptor.initCoreDirectory(tmp, sharedLibs);
                        client.uploadConfig(tmp.resolve("conf"), remoteName);
                        if (!existingCollections.contains(remoteName)) {
                            response = client.request((SolrRequest)CollectionAdminRequest.createCollection((String)remoteName, (String)remoteName, (int)Math.max(1, coreDescriptor.getNumShards()), (int)Math.max(2, coreDescriptor.getReplicationFactor())).setMaxShardsPerNode(this.config.getMaxShardsPerNode()));
                            this.log.debug("Created Collection {}, CoreAdminResponse: {}", (Object)coreName, (Object)response);
                            this.scheduleCoreInit(executorService, coreDescriptor, true);
                        } else {
                            this.log.debug("Collection {} already exists in SolrCloud '{}' as {}", new Object[]{coreName, this.config.getZkConnection(), remoteName});
                            response = client.request((SolrRequest)CollectionAdminRequest.reloadCollection((String)remoteName));
                            this.log.debug("Reloaded Collection {}, CoreAdminResponse: {}", (Object)coreName, (Object)response);
                            this.scheduleCoreInit(executorService, coreDescriptor, false);
                        }
                        this.availableCores.put(coreName, coreDescriptor);
                        continue;
                    }
                    catch (SolrServerException e) {
                        this.log.debug("Initializing core {} ({}) failed: {}", new Object[]{coreName, remoteName, e.getMessage()});
                        throw new IOException(String.format("Initializing collection %s (%s) failed", coreName, remoteName), e);
                    }
                    finally {
                        PathUtils.deleteRecursive((Path)tmp);
                        continue;
                    }
                }
                if (existingCollections.contains(remoteName)) {
                    this.log.debug("Collection {} exists in SolrCloud '{}' as {}", new Object[]{coreName, this.config.getZkConnection(), remoteName});
                    this.scheduleCoreInit(executorService, coreDescriptor, false);
                    this.availableCores.put(coreName, coreDescriptor);
                    continue;
                }
                this.log.warn("Collection {} (remote: {}) not available in SolrCloud '{}' but deployCores is set to false", new Object[]{coreName, remoteName, this.config.getZkConnection()});
            }
            this.log.info("Initialized {} collections in Solr-Cloud {}: {}", new Object[]{this.availableCores.size(), this.config.getZkConnection(), this.availableCores});
        }
        catch (IOException e) {
            throw e;
        }
        catch (SolrServerException e) {
            this.log.error("Could not list existing collections: {}", (Object)e.getMessage(), (Object)e);
            throw new IOException("Could not list existing collections", e);
        }
        catch (Throwable t) {
            this.log.error("Unexpected {} during init(): {}", new Object[]{t.getClass().getSimpleName(), t.getMessage(), t});
            throw t;
        }
        finally {
            PathUtils.deleteRecursive((Path)sharedLibs);
        }
    }

    protected String createRemoteName(String coreName) {
        return this.prefix + coreName;
    }

    protected CloudSolrClient createSolrClient() {
        return new CloudSolrClient.Builder().withZkHost(this.config.getZkConnection()).build();
    }

    protected SolrClient createSolrClient(String coreName) {
        CloudSolrClient solrClient = this.createSolrClient();
        solrClient.setDefaultCollection(this.createRemoteName(coreName));
        return solrClient;
    }
}

