/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.lucene.search.suggest;

import io.redlink.lucene.search.suggest.FreeTextSuggester;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.LookupFactory;

public class FreeTextSuggesterFactory
extends LookupFactory {
    public static final String QUERY_ANALYZER = "suggestFreeTextAnalyzerFieldType";
    public static final String NGRAMS = "ngrams";
    public static final String SEPARATOR = "separator";
    public static final String ALPHA = "alpha";
    private static final String FILENAME = "ftsta.bin";

    public Lookup create(NamedList params, SolrCore core) {
        Object fieldTypeName = params.get(QUERY_ANALYZER);
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestFreeTextAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getLatestSchema().getFieldTypeByName(fieldTypeName.toString());
        if (ft == null) {
            throw new IllegalArgumentException("Error in configuration: " + fieldTypeName.toString() + " is not defined in the schema");
        }
        Analyzer indexAnalyzer = ft.getIndexAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        int grams = params.get(NGRAMS) != null ? Integer.parseInt(params.get(NGRAMS).toString()) : 2;
        byte separator = params.get(SEPARATOR) != null ? params.get(SEPARATOR).toString().getBytes(StandardCharsets.UTF_8)[0] : (byte)30;
        double alpha = params.get(ALPHA) != null ? Double.parseDouble(params.get(ALPHA).toString()) : 0.4;
        return new FreeTextSuggester(indexAnalyzer, queryAnalyzer, grams, separator, alpha);
    }

    public String storeFileName() {
        return FILENAME;
    }
}

