/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.lucene.search.suggest;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeTextSuggester
extends Lookup
implements Accountable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String CODEC_NAME = "freetextsuggest";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final int DEFAULT_GRAMS = 2;
    public static final double DEFAULT_ALPHA = 0.4;
    private FST<Long> fst;
    private final Analyzer indexAnalyzer;
    private long totTokens;
    private final Analyzer queryAnalyzer;
    private final int grams;
    private final byte separator;
    private long count = 0L;
    private double alpha;
    public static final byte DEFAULT_SEPARATOR = 30;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public FreeTextSuggester(Analyzer analyzer) {
        this(analyzer, analyzer, 2);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, queryAnalyzer, 2);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams) {
        this(indexAnalyzer, queryAnalyzer, grams, 30);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams, byte separator) {
        this(indexAnalyzer, queryAnalyzer, grams, separator, 0.4);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams, byte separator, double alpha) {
        this.grams = grams;
        this.indexAnalyzer = this.addShingles(indexAnalyzer);
        this.queryAnalyzer = this.addShingles(queryAnalyzer);
        if (grams < 1) {
            throw new IllegalArgumentException("grams must be >= 1");
        }
        if ((separator & 0x80) != 0) {
            throw new IllegalArgumentException("separator must be simple ascii character");
        }
        this.separator = separator;
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new IllegalArgumentException("alpha must be [0..1] (parsed: " + alpha + ")");
        }
        this.alpha = alpha;
    }

    public long ramBytesUsed() {
        if (this.fst == null) {
            return 0L;
        }
        return this.fst.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        if (this.fst == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Accountables.namedAccountable((String)"fst", this.fst));
    }

    private Analyzer addShingles(final Analyzer other) {
        if (this.grams == 1) {
            return other;
        }
        return new AnalyzerWrapper(other.getReuseStrategy()){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return other;
            }

            protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                ShingleFilter shingles = new ShingleFilter(components.getTokenStream(), 2, FreeTextSuggester.this.grams);
                shingles.setTokenSeparator(Character.toString((char)FreeTextSuggester.this.separator));
                return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)shingles);
            }
        };
    }

    public void build(InputIterator iterator) throws IOException {
        this.build(iterator, 16.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(InputIterator iterator, double ramBufferSizeMB) throws IOException {
        Path tempIndexPath;
        block16: {
            if (iterator.hasPayloads()) {
                throw new IllegalArgumentException("this suggester doesn't support payloads");
            }
            if (iterator.hasContexts()) {
                throw new IllegalArgumentException("this suggester doesn't support contexts");
            }
            String prefix = ((Object)((Object)this)).getClass().getSimpleName();
            tempIndexPath = Files.createTempDirectory(prefix + ".index.", new FileAttribute[0]);
            FSDirectory dir = FSDirectory.open((Path)tempIndexPath);
            IndexWriterConfig iwc = new IndexWriterConfig(this.indexAnalyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            iwc.setRAMBufferSizeMB(ramBufferSizeMB);
            IndexWriter writer = new IndexWriter((Directory)dir, iwc);
            FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
            ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
            ft.setOmitNorms(true);
            ft.freeze();
            Document doc = new Document();
            Field field = new Field("body", (CharSequence)"", (IndexableFieldType)ft);
            doc.add((IndexableField)field);
            this.totTokens = 0L;
            DirectoryReader reader = null;
            boolean success = false;
            this.count = 0L;
            try {
                BytesRef term;
                BytesRef surfaceForm;
                while ((surfaceForm = iterator.next()) != null) {
                    field.setStringValue(surfaceForm.utf8ToString());
                    writer.addDocument((Iterable)doc);
                    ++this.count;
                }
                reader = DirectoryReader.open((IndexWriter)writer);
                Terms terms = MultiTerms.getTerms((IndexReader)reader, (String)"body");
                if (terms == null) {
                    throw new IllegalArgumentException("need at least one suggestion");
                }
                TermsEnum termsEnum = terms.iterator();
                PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
                Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
                IntsRefBuilder scratchInts = new IntsRefBuilder();
                while ((term = termsEnum.next()) != null) {
                    int ngramCount = this.countGrams(term);
                    if (ngramCount > this.grams) {
                        throw new IllegalArgumentException("tokens must not contain separator byte; got token=" + term + " but gramCount=" + ngramCount + ", which is greater than expected max ngram size=" + this.grams);
                    }
                    if (ngramCount == 1) {
                        this.totTokens += termsEnum.totalTermFreq();
                    }
                    builder.add(Util.toIntsRef((BytesRef)term, (IntsRefBuilder)scratchInts), (Object)this.encodeWeight(termsEnum.totalTermFreq()));
                }
                this.fst = builder.finish();
                if (this.fst == null) {
                    throw new IllegalArgumentException("need at least one suggestion");
                }
                this.log.debug("FST: {} bytes", (Object)this.fst.ramBytesUsed());
                writer.rollback();
                success = true;
            }
            catch (Throwable throwable) {
                block17: {
                    try {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{reader, dir});
                            break block17;
                        }
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer, dir});
                    }
                    catch (Throwable throwable2) {
                        IOUtils.rm((Path[])new Path[]{tempIndexPath});
                        throw throwable2;
                    }
                }
                IOUtils.rm((Path[])new Path[]{tempIndexPath});
                throw throwable;
            }
            try {
                if (success) {
                    IOUtils.close((Closeable[])new Closeable[]{reader, dir});
                    break block16;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer, dir});
            }
            catch (Throwable throwable) {
                IOUtils.rm((Path[])new Path[]{tempIndexPath});
                throw throwable;
            }
        }
        IOUtils.rm((Path[])new Path[]{tempIndexPath});
    }

    public boolean store(DataOutput output) throws IOException {
        CodecUtil.writeHeader((DataOutput)output, (String)CODEC_NAME, (int)0);
        output.writeVLong(this.count);
        output.writeByte(this.separator);
        output.writeVInt(this.grams);
        output.writeVLong(this.totTokens);
        this.fst.save(output);
        return true;
    }

    public boolean load(DataInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)0);
        this.count = input.readVLong();
        byte separatorOrig = input.readByte();
        if (separatorOrig != this.separator) {
            throw new IllegalStateException("separator=" + this.separator + " is incorrect: original model was built with separator=" + separatorOrig);
        }
        int gramsOrig = input.readVInt();
        if (gramsOrig != this.grams) {
            throw new IllegalStateException("grams=" + this.grams + " is incorrect: original model was built with grams=" + gramsOrig);
        }
        this.totTokens = input.readVLong();
        this.fst = new FST(input, (Outputs)PositiveIntOutputs.getSingleton());
        return true;
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        return this.lookup(key, null, onlyMorePopular, num);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, int num) {
        return this.lookup(key, null, true, num);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        try {
            return this.lookup(key, contexts, num);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public long getCount() {
        return this.count;
    }

    private int countGrams(BytesRef token) {
        int count = 1;
        for (int i = 0; i < token.length; ++i) {
            if (token.bytes[token.offset + i] != this.separator) continue;
            ++count;
        }
        return count;
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num) throws IOException {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        if (this.fst == null) {
            throw new IllegalStateException("Lookup not supported at this time");
        }
        try (TokenStream ts = this.queryAnalyzer.tokenStream("", key.toString());){
            TermToBytesRefAttribute termBytesAtt = (TermToBytesRefAttribute)ts.addAttribute(TermToBytesRefAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            PositionLengthAttribute posLenAtt = (PositionLengthAttribute)ts.addAttribute(PositionLengthAttribute.class);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
            ts.reset();
            LinkedList<String> tokens = new LinkedList<String>();
            BytesRefBuilder[] lastTokens = new BytesRefBuilder[this.grams];
            int[] lastTokensOffset = new int[this.grams];
            this.log.debug("lookup: key='{}'", (Object)key);
            int tokenOffset = -1;
            int maxEndOffset = -1;
            boolean sawRealToken = false;
            while (ts.incrementToken()) {
                BytesRef tokenBytes = termBytesAtt.getBytesRef();
                sawRealToken |= tokenBytes.length > 0;
                int gramCount = posLenAtt.getPositionLength();
                assert (gramCount <= this.grams);
                if (this.countGrams(tokenBytes) != gramCount) {
                    throw new IllegalArgumentException("tokens must not contain separator byte; got token=" + tokenBytes + " but gramCount=" + gramCount + " does not match recalculated count=" + this.countGrams(tokenBytes));
                }
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
                BytesRefBuilder b = new BytesRefBuilder();
                b.append(tokenBytes);
                lastTokens[gramCount - 1] = b;
                lastTokensOffset[gramCount - 1] = tokenOffset += posIncAtt.getPositionIncrement();
                if (gramCount != 1) continue;
                tokens.add(b.get().utf8ToString());
            }
            ts.end();
            if (!sawRealToken) {
                throw new IllegalArgumentException("no tokens produced by analyzer, or the only tokens were empty strings");
            }
            int endPosInc = posIncAtt.getPositionIncrement();
            boolean lastTokenEnded = offsetAtt.endOffset() > maxEndOffset || endPosInc > 0;
            this.log.debug("maxEndOffset={} vs {}", (Object)maxEndOffset, (Object)offsetAtt.endOffset());
            if (lastTokenEnded) {
                this.log.debug(" lastTokenEnded");
                int maxOffset = -1;
                for (int i = this.grams - 1; i > 0; --i) {
                    BytesRefBuilder token = lastTokens[i - 1];
                    int offset = lastTokensOffset[i - 1];
                    if (token == null) continue;
                    token.append(this.separator);
                    lastTokens[i] = token;
                    lastTokensOffset[i] = offset;
                    maxOffset = Math.max(maxOffset, offset);
                }
                lastTokens[0] = new BytesRefBuilder();
                lastTokensOffset[0] = maxOffset + 1;
            }
            FST.Arc arc = new FST.Arc();
            FST.BytesReader bytesReader = this.fst.getBytesReader();
            double backoff = 1.0;
            ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
            final HashSet<BytesRef> seen = new HashSet<BytesRef>();
            for (int gram = this.grams - 1; gram >= 0; --gram) {
                BytesRefBuilder token = lastTokens[gram];
                int offset = lastTokensOffset[gram];
                if (token == null || token.length() == 0 && key.length() > 0) {
                    this.log.debug(" gram={}: skip: not enough input", (Object)gram);
                    continue;
                }
                if (endPosInc > 0 && gram <= endPosInc) {
                    this.log.debug(" break: only holes now");
                    break;
                }
                this.log.debug("try {} gram token={}", (Object)(gram + 1), (Object)token.get().utf8ToString());
                Long prefixOutput = null;
                try {
                    prefixOutput = this.lookupPrefix(this.fst, bytesReader, token.get(), (FST.Arc<Long>)arc);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                this.log.debug(" prefixOutput={}", (Object)prefixOutput);
                if (prefixOutput == null) {
                    backoff *= 0.4;
                    continue;
                }
                long contextCount = this.totTokens;
                BytesRef lastTokenFragment = null;
                for (int i = token.length() - 1; i >= 0; --i) {
                    if (token.byteAt(i) != this.separator) continue;
                    BytesRef context = new BytesRef(token.bytes(), 0, i);
                    Long output = (Long)Util.get(this.fst, (IntsRef)Util.toIntsRef((BytesRef)context, (IntsRefBuilder)new IntsRefBuilder()));
                    assert (output != null);
                    contextCount = this.decodeWeight(output);
                    lastTokenFragment = new BytesRef(token.bytes(), i + 1, token.length() - i - 1);
                    break;
                }
                final BytesRefBuilder finalLastToken = new BytesRefBuilder();
                if (lastTokenFragment == null) {
                    finalLastToken.copyBytes(token.get());
                } else {
                    finalLastToken.copyBytes(lastTokenFragment);
                }
                CharsRefBuilder spare = new CharsRefBuilder();
                Util.TopResults completions = null;
                try {
                    Util.TopNSearcher<Long> searcher = new Util.TopNSearcher<Long>(this.fst, num, num + seen.size(), weightComparator){
                        BytesRefBuilder scratchBytes;
                        {
                            super(x0, x1, x2, x3);
                            this.scratchBytes = new BytesRefBuilder();
                        }

                        protected void addIfCompetitive(Util.FSTPath<Long> path) {
                            if (FreeTextSuggester.this.log.isTraceEnabled()) {
                                FreeTextSuggester.this.log.trace(" {} path: {}", (Object)(path.arc.label() != FreeTextSuggester.this.separator ? "keep" : "prevent"), (Object)(Util.toBytesRef((IntsRef)path.input.get(), (BytesRefBuilder)new BytesRefBuilder()).utf8ToString() + "; " + path + "; arc=" + path.arc));
                            }
                            if (path.arc.label() != FreeTextSuggester.this.separator) {
                                super.addIfCompetitive(path);
                            }
                        }

                        protected boolean acceptResult(IntsRef input, Long output) {
                            Util.toBytesRef((IntsRef)input, (BytesRefBuilder)this.scratchBytes);
                            finalLastToken.grow(finalLastToken.length() + this.scratchBytes.length());
                            int lenSav = finalLastToken.length();
                            finalLastToken.append(this.scratchBytes);
                            if (FreeTextSuggester.this.log.isTraceEnabled()) {
                                FreeTextSuggester.this.log.trace(" accept? input='{}'; lastToken='{}'; return {}", new Object[]{this.scratchBytes.get().utf8ToString(), finalLastToken.get().utf8ToString(), !seen.contains(finalLastToken.get())});
                            }
                            boolean ret = !seen.contains(finalLastToken.get());
                            finalLastToken.setLength(lenSav);
                            return ret;
                        }
                    };
                    searcher.addStartPaths(arc, (Object)prefixOutput, true, new IntsRefBuilder());
                    completions = searcher.search();
                    assert (completions.isComplete);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                int prefixLength = token.length();
                BytesRefBuilder suffix = new BytesRefBuilder();
                this.log.debug(" {} completions", (Object)completions.topN.size());
                for (Util.Result completion : completions) {
                    token.setLength(prefixLength);
                    Util.toBytesRef((IntsRef)completion.input, (BytesRefBuilder)suffix);
                    token.append(suffix);
                    this.log.debug(" completion {}", (Object)token.get().utf8ToString());
                    BytesRef lastToken = token.get();
                    for (int i = token.length() - 1; i >= 0; --i) {
                        if (token.byteAt(i) != this.separator) continue;
                        assert (token.length() - i - 1 > 0);
                        lastToken = new BytesRef(token.bytes(), i + 1, token.length() - i - 1);
                        break;
                    }
                    if (seen.contains(lastToken)) {
                        this.log.debug(" skip dup {}", (Object)lastToken.utf8ToString());
                        continue;
                    }
                    seen.add(BytesRef.deepCopyOf((BytesRef)lastToken));
                    spare.copyUTF8Bytes(token.get());
                    Lookup.LookupResult result = new Lookup.LookupResult(this.getHighlightKey(tokens, offset, token, suffix), (long)(9.223372036854776E18 * backoff * (double)this.decodeWeight((Long)completion.output) / (double)contextCount), this.getSuggestionPayload(tokens, offset, token, suffix));
                    results.add(result);
                    assert (results.size() == seen.size());
                    this.log.debug(" add result={}", (Object)result);
                }
                backoff *= this.alpha;
            }
            Collections.sort(results, new Comparator<Lookup.LookupResult>(){

                @Override
                public int compare(Lookup.LookupResult a, Lookup.LookupResult b) {
                    if (a.value > b.value) {
                        return -1;
                    }
                    if (a.value < b.value) {
                        return 1;
                    }
                    return ((String)a.key).compareTo((String)b.key);
                }
            });
            if (results.size() > num) {
                results.subList(num, results.size()).clear();
            }
            ArrayList<Lookup.LookupResult> arrayList = results;
            return arrayList;
        }
    }

    private BytesRef getSuggestionPayload(List<String> tokens, int offset, BytesRefBuilder token, BytesRefBuilder suffix) {
        BytesRefBuilder sug = new BytesRefBuilder();
        tokens.stream().limit(offset).map(BytesRef::new).forEach(tb -> {
            sug.append(tb);
            sug.append(this.separator);
        });
        sug.append(token);
        return sug.get();
    }

    private CharSequence getHighlightKey(List<String> tokens, int offset, BytesRefBuilder token, BytesRefBuilder suffix) {
        this.log.debug("build Hoghlights for tokens: {} |\u00a0token: {} | suffix: {}", new Object[]{tokens, token.get().utf8ToString(), suffix.get().utf8ToString()});
        String sep = Character.toString((char)this.separator);
        String hl = tokens.stream().limit(offset).collect(Collectors.joining(sep)) + sep + "<em>" + token.get().utf8ToString() + "</em>";
        return hl;
    }

    private long encodeWeight(long ngramCount) {
        return Long.MAX_VALUE - ngramCount;
    }

    private long decodeWeight(Long output) {
        assert (output != null);
        return (int)(Long.MAX_VALUE - output);
    }

    private Long lookupPrefix(FST<Long> fst, FST.BytesReader bytesReader, BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        Long output = (Long)fst.outputs.getNoOutput();
        fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output = (Long)fst.outputs.add((Object)output, arc.output());
        }
        return output;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }
}

