/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class VersionHelper {
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d)+\\.(\\d)+(\\.\\d+)?(\\-SNAPSHOT)?");
    public static final String VERSION = "1.0";

    public static String getVersion() {
        Package aPackage;
        String version = null;
        try {
            Properties p = new Properties();
            InputStream is = VersionHelper.class.getResourceAsStream("/META-INF/maven/io.redlink/redlink-sdk-java/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        if (version == null && (aPackage = VersionHelper.class.getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            try {
                Model model = reader.read((Reader)new FileReader(new File("pom.xml")));
                version = model.getVersion();
            }
            catch (IOException | XmlPullParserException throwable) {
                // empty catch block
            }
        }
        return version;
    }

    public static String getApiVersion() {
        String version = VersionHelper.getVersion();
        return VersionHelper.formatApiVersion(version);
    }

    protected static String formatApiVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return VERSION;
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return String.format("%s.%s", matcher.group(1), matcher.group(2));
        }
        return VERSION;
    }
}

