/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.redlink.sdk.Credentials;
import io.redlink.sdk.RedLink;
import io.redlink.sdk.impl.RedLinkAbstractImpl;
import io.redlink.sdk.impl.data.model.LDPathResult;
import io.redlink.sdk.util.UriBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.marmotta.client.model.rdf.RDFNode;
import org.apache.marmotta.client.model.sparql.SPARQLResult;
import org.apache.marmotta.client.util.RDFJSONParser;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.query.resultio.helpers.QueryResultCollector;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.ParseErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedLinkDataImpl
extends RedLinkAbstractImpl
implements RedLink.Data {
    private static final long serialVersionUID = 4326250513301297236L;
    private static Logger log = LoggerFactory.getLogger(RedLinkDataImpl.class);

    public RedLinkDataImpl(Credentials credentials) {
        super(credentials);
    }

    @Override
    public boolean importDataset(Model data, String dataset) throws RDFHandlerException {
        return this.importDataset(data, dataset, false);
    }

    @Override
    public boolean importDataset(Model data, String dataset, boolean cleanBefore) throws RDFHandlerException {
        RDFFormat format = RDFFormat.TURTLE;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Rio.write((Iterable)data, (OutputStream)out, (RDFFormat)format);
        return this.importDataset(new ByteArrayInputStream(out.toByteArray()), format, dataset, cleanBefore);
    }

    @Override
    public boolean importDataset(File file, String dataset) throws FileNotFoundException {
        return this.importDataset(file, dataset, false);
    }

    @Override
    public boolean importDataset(File file, String dataset, boolean cleanBefore) throws FileNotFoundException {
        return this.importDataset(new FileInputStream(file), RDFFormat.forFileName((String)file.getAbsolutePath()), dataset, cleanBefore);
    }

    @Override
    public boolean importDataset(InputStream in, RDFFormat format, String dataset) {
        return this.importDataset(in, format, dataset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importDataset(InputStream in, RDFFormat format, String dataset, boolean cleanBefore) {
        boolean bl;
        log.debug("Importing {} data into dataset {}", (Object)format.getName(), (Object)dataset);
        java.net.URI target = this.credentials.buildUrl(this.getDatasetUriBuilder(dataset));
        CloseableHttpResponse response = cleanBefore ? this.client.put(target, in, format) : this.client.post(target, in, format);
        try {
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            bl = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                log.error("Error importing dataset: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        response.close();
        return bl;
    }

    @Override
    public Model exportDataset(String dataset) {
        RDFFormat format = RDFFormat.TURTLE;
        try {
            java.net.URI target = this.credentials.buildUrl(this.getDatasetUriBuilder(dataset));
            log.debug("Exporting {} data from dataset {}", (Object)format.getName(), (Object)dataset);
            String entity = this.client.get(target, format.getDefaultMIMEType());
            return Rio.parse((Reader)new StringReader(entity), (String)target.toString(), (RDFFormat)format, (ParserConfig)new ParserConfig(), (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | RDFParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanDataset(String dataset) {
        boolean bl;
        java.net.URI target = this.credentials.buildUrl(this.getDatasetUriBuilder(dataset));
        log.debug("Cleaning data from dataset {}", (Object)dataset);
        CloseableHttpResponse response = this.client.delete(target);
        log.debug("Request resolved with {} status code: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
        try {
            int status = response.getStatusLine().getStatusCode();
            bl = status >= 200 && status < 300;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        response.close();
        return bl;
    }

    @Override
    public Model getResource(String resource) {
        try {
            return this.getResource(this.getResourceUriBuilder(resource));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Model getResource(String resource, String dataset) {
        try {
            return this.getResource(this.getResourceUriBuilder(dataset, resource));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Model getResource(UriBuilder uriBuilder) {
        RDFFormat format = RDFFormat.TURTLE;
        try {
            java.net.URI target = this.credentials.buildUrl(uriBuilder);
            log.debug("Exporting {} data from resource {}", (Object)format.getName(), (Object)target.toString());
            String entity = this.client.get(target, format.getDefaultMIMEType());
            return Rio.parse((Reader)new StringReader(entity), (String)target.toString(), (RDFFormat)format, (ParserConfig)new ParserConfig(), (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | RDFParseException e) {
            if (e instanceof ClientProtocolException && "Unexpected response status: 404".compareTo(e.getMessage()) == 0) {
                return new LinkedHashModel();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean importResource(String resource, Model data, String dataset) {
        return this.importResource(resource, data, dataset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importResource(String resource, Model data, String dataset, boolean cleanBefore) {
        boolean bl;
        RDFFormat format = RDFFormat.TURTLE;
        log.debug("Importing {} data for resource {} in {}", new Object[]{format.getName(), resource, dataset});
        java.net.URI target = this.credentials.buildUrl(this.getResourceUriBuilder(dataset, resource));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Rio.write((Iterable)data, (OutputStream)out, (RDFFormat)format);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        CloseableHttpResponse response = cleanBefore ? this.client.put(target, in, format) : this.client.post(target, in, format);
        try {
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            bl = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException | RDFHandlerException e) {
                log.error("Error importing resource: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        response.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteResource(String resource, String dataset) {
        boolean bl;
        java.net.URI target = this.credentials.buildUrl(this.getResourceUriBuilder(dataset, resource));
        log.debug("Cleaning data from resource {} in {}", (Object)resource, (Object)dataset);
        CloseableHttpResponse response = this.client.delete(target);
        log.debug("Request resolved with {} status code: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
        try {
            int status = response.getStatusLine().getStatusCode();
            bl = status >= 200 && status < 300;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        response.close();
        return bl;
    }

    @Override
    public SPARQLResult sparqlTupleQuery(String query) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder());
            return this.execTupleQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public SPARQLResult sparqlSelect(String query) {
        return this.sparqlTupleQuery(query);
    }

    @Override
    public SPARQLResult sparqlTupleQuery(String query, String dataset) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder(dataset));
            return this.execTupleQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public SPARQLResult sparqlSelect(String query, String dataset) {
        return this.sparqlTupleQuery(query, dataset);
    }

    @Override
    public Model sparqlGraphQuery(String query) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder());
            return this.execGraphQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Model sparqlGraphQuery(String query, String dataset) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder(dataset));
            return this.execGraphQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean sparqlUpdate(String query, String dataset) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getSparqlUpdateUriBuilder(dataset));
            return this.execUpdate(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LDPathResult ldpath(String uri, String dataset, String program) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getLDPathUriBuilder(dataset, uri));
            return this.execLDPath(target, uri, program);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LDPathResult ldpath(String uri, String program) {
        try {
            java.net.URI target = this.credentials.buildUrl(this.getLDPathUriBuilder(uri));
            return this.execLDPath(target, uri, program);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(String dataset) {
        boolean bl;
        java.net.URI target = this.credentials.buildUrl(this.getReleaseUriBuilder(dataset));
        log.debug("Releasing dataset {}", (Object)dataset);
        CloseableHttpResponse response = this.client.post(target, "application/json");
        log.debug("Request resolved with {} status code: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
        try {
            int status = response.getStatusLine().getStatusCode();
            bl = status >= 200 && status < 300;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        response.close();
        return bl;
    }

    private final UriBuilder getDatasetUriBuilder(String dataset) throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path(dataset);
    }

    private final UriBuilder getResourceUriBuilder(String resource) throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path("resource").queryParam("uri", resource);
    }

    private final UriBuilder getResourceUriBuilder(String dataset, String resource) throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path(dataset).path("resource").queryParam("uri", resource);
    }

    private final UriBuilder getSparqlSelectUriBuilder() throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path("sparql");
    }

    private final UriBuilder getSparqlSelectUriBuilder(String dataset) throws URISyntaxException {
        return this.getDatasetUriBuilder(dataset).path("sparql").path("select");
    }

    private final UriBuilder getSparqlUpdateUriBuilder(String dataset) throws URISyntaxException {
        return this.getDatasetUriBuilder(dataset).path("sparql").path("update");
    }

    private final UriBuilder getLDPathUriBuilder(String uri) throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path("ldpath").queryParam("uri", uri);
    }

    private final UriBuilder getLDPathUriBuilder(String dataset, String uri) throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path(dataset).path("ldpath").queryParam("uri", uri);
    }

    private final UriBuilder getReleaseUriBuilder(String dataset) throws URISyntaxException {
        return this.initiateUriBuilding().path("data").path(dataset).path("release");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SPARQLResult execTupleQuery(java.net.URI target, String query) {
        SPARQLResult sPARQLResult;
        SPARQLResult result;
        List fieldNames;
        block19: {
            try {
                log.debug("Executing SPARQL tuple query: {}", (Object)query.replaceAll("\\s*[\\r\\n]+\\s*", " ").trim());
                TupleQueryResultFormat format = TupleQueryResultFormat.JSON;
                CloseableHttpResponse response = this.client.post(target, query, format.getDefaultMIMEType());
                int status = response.getStatusLine().getStatusCode();
                log.debug("Request resolved with {} status code: {}", (Object)status, (Object)response.getStatusLine().getReasonPhrase());
                try {
                    if (status >= 200 && status < 300) {
                        QueryResultCollector results = new QueryResultCollector();
                        this.parse(EntityUtils.toString((HttpEntity)response.getEntity()), format, (QueryResultHandler)results, (ValueFactory)ValueFactoryImpl.getInstance());
                        if (!results.getHandledTuple() || results.getBindingSets().isEmpty()) {
                            SPARQLResult sPARQLResult2 = new SPARQLResult(new LinkedHashSet());
                            return sPARQLResult2;
                        }
                        fieldNames = results.getBindingNames();
                        result = new SPARQLResult(new LinkedHashSet(fieldNames));
                        sPARQLResult = results.getBindingSets().iterator();
                        break block19;
                    }
                    throw new RuntimeException("Query failed: HTTP error code " + status + ": " + response.getStatusLine().getReasonPhrase());
                }
                catch (QueryResultHandlerException | QueryResultParseException e) {
                    log.error("Error parsing query results: {}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
                finally {
                    response.close();
                }
            }
            catch (IOException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        while (sPARQLResult.hasNext()) {
            BindingSet nextRow = (BindingSet)sPARQLResult.next();
            HashMap<String, org.apache.marmotta.client.model.rdf.URI> row = new HashMap<String, org.apache.marmotta.client.model.rdf.URI>();
            for (String nextBindingName : fieldNames) {
                if (!nextRow.hasBinding(nextBindingName)) continue;
                Binding nextBinding = nextRow.getBinding(nextBindingName);
                Value nodeDef = nextBinding.getValue();
                org.apache.marmotta.client.model.rdf.URI node = null;
                if (nodeDef instanceof URI) {
                    node = new org.apache.marmotta.client.model.rdf.URI(nodeDef.stringValue());
                } else if (nodeDef instanceof BNode) {
                    node = new org.apache.marmotta.client.model.rdf.BNode(((BNode)nodeDef).getID());
                } else if (nodeDef instanceof Literal) {
                    Literal nodeLiteral = (Literal)nodeDef;
                    node = nodeLiteral.getLanguage() != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel(), nodeLiteral.getLanguage()) : (nodeLiteral.getDatatype() != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel(), new org.apache.marmotta.client.model.rdf.URI(nodeLiteral.getDatatype().stringValue())) : new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel()));
                }
                if (node == null) continue;
                row.put(nextBindingName, node);
            }
            result.add(row);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model execGraphQuery(java.net.URI target, String query) {
        try {
            log.debug("Executing SPARQL tuple query: {}", (Object)query.replaceAll("\\s*[\\r\\n]+\\s*", " ").trim());
            RDFFormat format = RDFFormat.TURTLE;
            CloseableHttpResponse response = this.client.post(target, query, format.getDefaultMIMEType(), "application/sparql-query");
            int status = response.getStatusLine().getStatusCode();
            log.debug("Request resolved with {} status code: {}", (Object)status, (Object)response.getStatusLine().getReasonPhrase());
            try {
                if (status >= 200 && status < 300) {
                    String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                    Model model = Rio.parse((Reader)new StringReader(entity), (String)target.toString(), (RDFFormat)RDFFormat.TURTLE, (ParserConfig)new ParserConfig(), (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
                    return model;
                }
                throw new RuntimeException("Query failed: HTTP error code " + status + ": " + response.getStatusLine().getReasonPhrase());
            }
            catch (RDFParseException e) {
                log.error("Error parsing query results: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
            finally {
                response.close();
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execUpdate(java.net.URI target, String query) {
        boolean bl;
        log.debug("Executing SPARQL update query: {}", (Object)query.replaceAll("\\s*[\\r\\n]+\\s*", " ").trim());
        CloseableHttpResponse response = this.client.post(target, query, "application/json", "application/sparql-update");
        log.debug("Request resolved with {} status code: {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
        try {
            int status = response.getStatusLine().getStatusCode();
            bl = status >= 200 && status < 300;
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        response.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LDPathResult execLDPath(java.net.URI target, String uri, String program) {
        try {
            log.debug("Executing LDpath program over resource {}", (Object)uri);
            CloseableHttpResponse response = this.client.post(target, program, "application/json");
            int status = response.getStatusLine().getStatusCode();
            log.debug("Request resolved with {} status code: {}", (Object)status, (Object)response.getStatusLine().getReasonPhrase());
            try {
                if (status < 200) throw new RuntimeException("Query failed: HTTP error code " + status);
                if (status >= 300) throw new RuntimeException("Query failed: HTTP error code " + status);
                LDPathResult result = new LDPathResult();
                Map fields = (Map)new ObjectMapper().readValue(response.getEntity().getContent(), Map.class);
                for (Map.Entry field : fields.entrySet()) {
                    ArrayList<RDFNode> row = new ArrayList<RDFNode>();
                    for (Map node : (List)field.getValue()) {
                        row.add(RDFJSONParser.parseRDFJSONNode((Map)node));
                    }
                    result.add((String)field.getKey(), row);
                }
                LDPathResult lDPathResult = result;
                return lDPathResult;
            }
            finally {
                response.close();
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void parse(InputStream in, TupleQueryResultFormat format, QueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, QueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler(handler);
        parser.parseQueryResult(in);
    }

    private void parse(String str, TupleQueryResultFormat format, QueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, QueryResultHandlerException, UnsupportedQueryResultFormatException {
        this.parse(new ByteArrayInputStream(str.getBytes("UTF-8")), format, handler, valueFactory);
    }
}

