/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis.model;

import io.redlink.sdk.impl.analysis.AnalysisRequest;
import io.redlink.sdk.impl.analysis.model.EnhancementParserException;
import io.redlink.sdk.impl.analysis.model.EnhancementsParser;
import io.redlink.sdk.impl.analysis.model.RDFStructureParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.ContextStatementCollector;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnhancementsParserFactory {
    private static final Logger log = LoggerFactory.getLogger(EnhancementsParserFactory.class);
    private static final String REDLINK = "X-Redlink-Instance";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static final EnhancementsParser createDefaultParser(HttpResponse response) throws EnhancementParserException, IOException {
        Charset charset;
        ParserConfig config = new ParserConfig();
        config.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        String uri = response.getFirstHeader(REDLINK).getValue();
        if (uri == null || uri.isEmpty()) {
            uri = "urn:uuid-" + UUID.randomUUID().toString();
        }
        TreeModel result = new TreeModel();
        String charsetStr = ContentType.getOrDefault((HttpEntity)response.getEntity()).getCharset().displayName();
        if (charsetStr == null) {
            charset = UTF8;
        } else {
            try {
                charset = Charset.forName(charsetStr);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                log.warn("Unable to use charset '" + charsetStr + "'. Will fallback to UTF-8", (Throwable)e);
                charset = UTF8;
            }
        }
        InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), charset);
        try {
            MemValueFactory vf = new MemValueFactory();
            RDFFormat format = RDFFormat.forMIMEType((String)ContentType.getOrDefault((HttpEntity)response.getEntity()).getMimeType());
            RDFParser parser = Rio.createParser((RDFFormat)format, (ValueFactory)vf);
            parser.setParserConfig(config);
            parser.setRDFHandler((RDFHandler)new ContextStatementCollector((Collection)result, (ValueFactory)vf, new Resource[0]));
            parser.parse((Reader)reader, uri);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new EnhancementParserException("Error Parsing Analysis results", e);
        }
        catch (IOException e) {
            throw new EnhancementParserException("Unable to read Analysis response", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return new RDFStructureParser((Model)result);
    }

    public static final EnhancementsParser createParser(HttpResponse response) throws EnhancementParserException, IOException {
        String type = ContentType.getOrDefault((HttpEntity)response.getEntity()).getMimeType();
        AnalysisRequest.OutputFormat format = AnalysisRequest.OutputFormat.get(type);
        switch (format) {
            default: 
        }
        return EnhancementsParserFactory.createDefaultParser(response);
    }
}

