/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.redlink.sdk.util.VersionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateInputStream;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.openrdf.rio.RDFFormat;

public class RedLinkClient
implements Serializable {
    private static final long serialVersionUID = -6399964450824289653L;
    public static final int REQUEST_TIMEOUT = 60;
    public static final Map<String, InputStreamFactory> decoderRegistry;
    public static final InputStreamFactory GZIP;
    public static final InputStreamFactory DEFLATE;
    public static final InputStreamFactory IDENTITY;
    private transient CloseableHttpClient client;
    private final ObjectMapper mapper = new ObjectMapper();

    public RedLinkClient() {
        this.client = this.buildHttpClient();
    }

    private CloseableHttpClient buildHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        builder.setDefaultRequestConfig(config);
        builder.setUserAgent(String.format("RedlinkJavaSDK/%s", VersionHelper.getVersion()));
        try {
            InputStream fis = RedLinkClient.class.getResourceAsStream("/redlink-CA.crt");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(fis);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyStore.setCertificateEntry("redlink-CA", cert);
            tmf.init(keyStore);
            SSLContext ctx = SSLContext.getInstance("SSLv3");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)new NoopHostnameVerifier());
            Registry r = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(r);
            cm.setMaxTotal(100);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        builder.setContentDecoderRegistry(decoderRegistry);
        return builder.build();
    }

    public String get(URI target) throws IOException {
        return this.get(target, "");
    }

    public String get(URI target, String accept) throws IOException {
        ResponseHandler<String> handler = new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        };
        return this.get(target, accept, handler);
    }

    public <T> T get(URI target, Class<T> clazz) throws IOException {
        return this.get(target, clazz, null);
    }

    public <T> T get(URI target, final Class<T> clazz, String accept) throws IOException {
        ResponseHandler handler = new ResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return RedLinkClient.this.mapper.readValue(entity.getContent(), clazz);
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        };
        return this.get(target, accept, handler);
    }

    private <T> T get(URI target, String accept, ResponseHandler<T> handler) throws IOException {
        HttpGet get = new HttpGet(target);
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            get.setHeader("Accept", accept);
        }
        if (this.client == null) {
            this.client = this.buildHttpClient();
        }
        return (T)this.client.execute((HttpUriRequest)get, handler);
    }

    public CloseableHttpResponse put(URI target, InputStream in, RDFFormat format) throws IOException {
        return this.exec((HttpEntityEnclosingRequestBase)new HttpPut(target), in, format);
    }

    public CloseableHttpResponse post(URI target, InputStream in, RDFFormat format) throws IOException {
        return this.exec((HttpEntityEnclosingRequestBase)new HttpPost(target), in, format);
    }

    public CloseableHttpResponse post(URI target) throws IOException {
        return this.post(target, null);
    }

    public CloseableHttpResponse post(URI target, String accept) throws IOException {
        HttpPost post = new HttpPost(target);
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            post.setHeader("Accept", accept);
        }
        if (this.client == null) {
            this.client = this.buildHttpClient();
        }
        return this.client.execute((HttpUriRequest)post);
    }

    public CloseableHttpResponse post(URI target, String body, String accept) throws IOException {
        return this.exec((HttpEntityEnclosingRequestBase)new HttpPost(target), (HttpEntity)new StringEntity(body), accept, null);
    }

    public CloseableHttpResponse post(URI target, String body, String accept, String contentType) throws IOException {
        return this.exec((HttpEntityEnclosingRequestBase)new HttpPost(target), (HttpEntity)new StringEntity(body), accept, contentType);
    }

    public CloseableHttpResponse post(URI target, InputStream in, String accept, String contentType) throws IOException {
        return this.exec((HttpEntityEnclosingRequestBase)new HttpPost(target), (HttpEntity)new InputStreamEntity(in), accept, contentType);
    }

    private CloseableHttpResponse exec(HttpEntityEnclosingRequestBase req, HttpEntity entity, String accept, String format) throws IOException {
        req.setEntity(entity);
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            req.setHeader("Accept", accept);
        }
        if (StringUtils.isNotBlank((CharSequence)format)) {
            req.setHeader("Content-Type", format);
        }
        if (this.client == null) {
            this.client = this.buildHttpClient();
        }
        return this.client.execute((HttpUriRequest)req);
    }

    private CloseableHttpResponse exec(HttpEntityEnclosingRequestBase req, InputStream in, RDFFormat format) throws IOException {
        return this.exec(req, (HttpEntity)new InputStreamEntity(in), format);
    }

    private CloseableHttpResponse exec(HttpEntityEnclosingRequestBase req, HttpEntity entity, RDFFormat format) throws IOException {
        req.setEntity(entity);
        req.setHeader("Content-Type", format.getDefaultMIMEType());
        if (this.client == null) {
            this.client = this.buildHttpClient();
        }
        return this.client.execute((HttpUriRequest)req);
    }

    public CloseableHttpResponse delete(URI target) throws IOException {
        HttpDelete delete = new HttpDelete(target);
        if (this.client == null) {
            this.client = this.buildHttpClient();
        }
        return this.client.execute((HttpUriRequest)delete);
    }

    static {
        GZIP = new InputStreamFactory(){

            public InputStream create(InputStream in) throws IOException {
                return new GZIPInputStream(in);
            }
        };
        DEFLATE = new InputStreamFactory(){

            public InputStream create(InputStream in) throws IOException {
                return new DeflateInputStream(in);
            }
        };
        IDENTITY = new InputStreamFactory(){

            public InputStream create(InputStream in) throws IOException {
                return in;
            }
        };
        HashMap<String, InputStreamFactory> dr = new HashMap<String, InputStreamFactory>();
        dr.put("gzip", GZIP);
        dr.put("x-gzip", GZIP);
        dr.put("deflate", DEFLATE);
        dr.put("none", IDENTITY);
        decoderRegistry = Collections.unmodifiableMap(dr);
    }
}

