/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.model.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.marmotta.client.model.rdf.Literal;
import org.apache.marmotta.client.model.rdf.RDFNode;

public class Metadata
extends HashMap<String, Set<RDFNode>> {
    private static final long serialVersionUID = 1L;
    private String subject;

    public Metadata(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public RDFNode getFirst(String propertyUri) {
        Preconditions.checkNotNull(this.get(propertyUri));
        Preconditions.checkState(((Set)this.get(propertyUri)).iterator().hasNext());
        return (RDFNode)((Set)this.get(propertyUri)).iterator().next();
    }

    public static Metadata fromPropertiesMap(String resource, Map<String, String> map) {
        Metadata m = new Metadata(resource);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            m.put(entry.getKey(), ImmutableSet.of(new Literal(entry.getValue())));
        }
        return m;
    }

    public static Map<String, String> toPropertiesMap(Metadata metadata) {
        HashMap<String, String> result = new HashMap<String, String>();
        block0: for (Map.Entry entry : metadata.entrySet()) {
            for (RDFNode n : (Set)entry.getValue()) {
                if (!(n instanceof Literal)) continue;
                result.put((String)entry.getKey(), ((Literal)n).getContent());
                continue block0;
            }
        }
        return result;
    }
}

