/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class UriBuilder
extends URIBuilder {
    public UriBuilder() {
    }

    public UriBuilder(String string) throws URISyntaxException {
        super(string);
    }

    public UriBuilder(URI uri) {
        super(uri);
    }

    public UriBuilder(URIBuilder builder) throws URISyntaxException {
        this(builder.build());
    }

    public static UriBuilder fromUri(String uri) throws URISyntaxException {
        return new UriBuilder(uri);
    }

    public UriBuilder path(String path) throws URISyntaxException {
        path = path.trim();
        if (this.getPath().endsWith("/")) {
            return new UriBuilder(this.setPath(String.format("%s%s", this.getPath(), path)));
        }
        return new UriBuilder(this.setPath(String.format("%s/%s", this.getPath(), path)));
    }

    @Override
    public URIBuilder setPath(String path) {
        if (path.startsWith("/")) {
            return super.setPath(path);
        }
        return super.setPath("/" + path);
    }

    public UriBuilder queryParam(String param, String value) throws URISyntaxException {
        if (StringUtils.isNotBlank(param) && StringUtils.isNotBlank(value)) {
            return new UriBuilder(this.addParameter(param, value));
        }
        return this;
    }
}

