/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.RedLink;
import io.redlink.sdk.impl.RedLinkAbstractImpl;
import io.redlink.sdk.impl.analysis.AnalysisRequest;
import io.redlink.sdk.impl.analysis.model.EnhancementParserException;
import io.redlink.sdk.impl.analysis.model.Enhancements;
import io.redlink.sdk.impl.analysis.model.EnhancementsParser;
import io.redlink.sdk.impl.analysis.model.EnhancementsParserFactory;
import io.redlink.sdk.util.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedLinkAnalysisImpl
extends RedLinkAbstractImpl
implements RedLink.Analysis {
    private static final long serialVersionUID = 7226835583815170412L;
    private static final Logger log = LoggerFactory.getLogger(RedLinkAnalysisImpl.class);

    public RedLinkAnalysisImpl(Credentials credentials) {
        super(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enhancements enhance(AnalysisRequest request) {
        Enhancements enhancements;
        CloseableHttpResponse response = this.execEnhance(request);
        try {
            enhancements = this.parseResponse(response);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        response.close();
        return enhancements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T enhance(AnalysisRequest request, Class<T> responseType) {
        Object result;
        block15: {
            result = null;
            if (responseType.isAssignableFrom(Enhancements.class)) {
                AnalysisRequest finalRequest = request;
                if (request.getOutputMediaType().equals(AnalysisRequest.OutputFormat.JSON.value()) || request.getOutputMediaType().equals(AnalysisRequest.OutputFormat.XML.value())) {
                    finalRequest = AnalysisRequest.builder().setAnalysis(request.getAnalysis()).setContent(request.getContent()).setInputFormat(AnalysisRequest.InputFormat.valueOf(request.getInputFormat())).setOutputFormat(AnalysisRequest.OutputFormat.TURTLE).setConfidence(request.getConfidence()).setSummaries(request.getSummary()).setThumbnails(request.getThumbnail()).build();
                }
                result = this.enhance(finalRequest);
            } else {
                if (responseType.isAssignableFrom(String.class)) {
                    try (CloseableHttpResponse response = this.execEnhance(request);){
                        result = EntityUtils.toString(response.getEntity());
                        break block15;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (responseType.isAssignableFrom(InputStream.class)) {
                    try (CloseableHttpResponse response = this.execEnhance(request);){
                        result = IOUtils.toBufferedInputStream(response.getEntity().getContent());
                        break block15;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new UnsupportedOperationException("Unsupported Response Type " + responseType.getCanonicalName());
            }
        }
        return responseType.cast(result);
    }

    private CloseableHttpResponse execEnhance(AnalysisRequest request) {
        try {
            String analysis = request.getAnalysis();
            if (analysis == null) {
                List<String> analyses = this.status.getAnalyses();
                if (analyses.size() == 1) {
                    log.debug("using default analysis '{}'");
                    analysis = analyses.get(0);
                } else {
                    throw new IllegalArgumentException("not analysis found in the request");
                }
            }
            UriBuilder uriBuilder = this.getEnhanceUriBuilder(analysis).queryParam("in", request.getInputFormat()).queryParam("out", request.getOutputFormat()).queryParam("confidence", Double.toString(request.getConfidence())).queryParam("summary", Boolean.toString(request.getSummary())).queryParam("thumbnail", Boolean.toString(request.getThumbnail())).queryParam("enhancer.engines.dereference.ldpath", request.getLDPathProgram());
            for (String field : request.getFieldsToDereference()) {
                uriBuilder = uriBuilder.queryParam("enhancer.engines.dereference.fields", field);
            }
            log.debug("Making analysis request to " + uriBuilder.build().toString());
            URI target = this.credentials.buildUrl(uriBuilder);
            String format = request.getInputMediaType().is(AnalysisRequest.InputFormat.TEXT.value()) ? AnalysisRequest.InputFormat.TEXT.value().toString() : AnalysisRequest.InputFormat.OCTETSTREAM.value().toString();
            long pre = System.currentTimeMillis();
            CloseableHttpResponse res = this.client.post(target, request.getContent(), request.getOutputMediaType().toString(), format);
            int status = res.getStatusLine().getStatusCode();
            String time = String.format("%,d", System.currentTimeMillis() - pre);
            log.debug("Server response time was {} ms (status={})", (Object)time, (Object)status);
            if (status >= 200 && status < 300) {
                return res;
            }
            String msg = String.format("Enhancement failed: HTTP error code %d, message: %s", status, res.getStatusLine().getReasonPhrase());
            log.error(msg);
            log.trace(EntityUtils.toString(res.getEntity()));
            throw new RuntimeException(msg);
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Enhancements parseResponse(HttpResponse response) throws IOException {
        try {
            long pre = System.currentTimeMillis();
            EnhancementsParser parser = EnhancementsParserFactory.createParser(response);
            Enhancements enhancements = parser.createEnhancements();
            long time = System.currentTimeMillis() - pre;
            log.debug("Response Parse Time: " + time + " ms");
            return enhancements;
        }
        catch (EnhancementParserException e) {
            throw new RuntimeException("Enhancement failed: " + e.getMessage(), e);
        }
    }

    private final UriBuilder getEnhanceUriBuilder(String analysis) throws URISyntaxException {
        return this.initiateUriBuilding().path("analysis").path(analysis).path("enhance");
    }
}

