/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;

public class AnalysisRequest {
    private boolean consumed = false;
    private InputFormat inputFormat = InputFormat.TEXT;
    private OutputFormat outputFormat = OutputFormat.TURTLE;
    private Optional<InputStream> contentStream = Optional.absent();
    private Optional<File> contentFile = Optional.absent();
    private Optional<String> contentString = Optional.absent();
    private Optional<String> contentEncoding = Optional.absent();
    private Optional<String> analysis = Optional.absent();
    private double confidence = 0.85;
    private boolean summary = true;
    private boolean thumbnail = true;
    private ContentType contentType = ContentType.EMPTY;
    private Collection<String> dereferencedFields = Sets.newHashSet();
    private Optional<String> ldpath = Optional.absent();

    public String getInputFormat() {
        return this.inputFormat.name();
    }

    public MediaType getInputMediaType() {
        return this.inputFormat.type;
    }

    public String getOutputFormat() {
        return this.outputFormat.name();
    }

    public MediaType getOutputMediaType() {
        return this.outputFormat.type;
    }

    public InputStream getContent() {
        switch (this.contentType) {
            case EMPTY: {
                throw new RuntimeException("There is not Content available to analyze");
            }
            case FILE: {
                if (!this.consumed) break;
                try {
                    this.contentStream = Optional.of(new FileInputStream(this.contentFile.get()));
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            case STRING: {
                if (!this.consumed) break;
                if (this.contentEncoding.isPresent()) {
                    try {
                        this.contentStream = Optional.of(IOUtils.toInputStream(this.contentString.get(), this.contentEncoding.get()));
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.contentStream = Optional.of(IOUtils.toInputStream(this.contentString.get()));
                break;
            }
            case INPUTSTREAM: {
                if (!this.consumed) break;
                throw new RuntimeException("The Content Stream to be analyzed has been already consumed");
            }
        }
        this.consumed = true;
        return this.contentStream.get();
    }

    public String getAnalysis() {
        return this.analysis.orNull();
    }

    public boolean getSummary() {
        return this.summary;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public boolean getThumbnail() {
        return this.thumbnail;
    }

    public Collection<String> getFieldsToDereference() {
        return this.dereferencedFields;
    }

    public String getLDPathProgram() {
        return this.ldpath.orNull();
    }

    public static AnalysisRequestBuilder builder() {
        return new AnalysisRequestBuilder();
    }

    public static class AnalysisRequestBuilder {
        private final AnalysisRequest request = new AnalysisRequest();

        public AnalysisRequestBuilder setInputFormat(InputFormat inputFormat) {
            this.request.inputFormat = inputFormat;
            return this;
        }

        public AnalysisRequestBuilder setOutputFormat(OutputFormat outputFormat) {
            this.request.outputFormat = outputFormat;
            return this;
        }

        public AnalysisRequestBuilder setAnalysis(String analysis) {
            this.request.analysis = Optional.of(analysis);
            return this;
        }

        public AnalysisRequestBuilder setConfidence(double confidence) {
            this.request.confidence = confidence;
            return this;
        }

        public AnalysisRequestBuilder setSummaries(boolean summary) {
            this.request.summary = summary;
            return this;
        }

        public AnalysisRequestBuilder setThumbnails(boolean thumbnail) {
            this.request.thumbnail = thumbnail;
            return this;
        }

        public AnalysisRequestBuilder setContent(String content) {
            this.request.contentStream = Optional.of(IOUtils.toInputStream(content));
            this.request.contentString = Optional.of(content);
            this.request.contentType = ContentType.STRING;
            return this;
        }

        public AnalysisRequestBuilder setContent(String content, String encoding) throws IOException {
            this.request.contentStream = Optional.of(IOUtils.toInputStream(content, encoding));
            this.request.contentString = Optional.of(content);
            this.request.contentEncoding = Optional.of(encoding);
            this.request.contentType = ContentType.STRING;
            return this;
        }

        public AnalysisRequestBuilder setContent(File file) throws FileNotFoundException {
            this.request.contentStream = Optional.of(new FileInputStream(file));
            this.request.contentFile = Optional.of(file);
            this.request.contentType = ContentType.FILE;
            return this;
        }

        public AnalysisRequestBuilder setContent(InputStream stream) {
            this.request.contentStream = Optional.of(stream);
            this.request.contentType = ContentType.INPUTSTREAM;
            return this;
        }

        public AnalysisRequestBuilder setLDpathProgram(String ldpathProgram) {
            this.request.ldpath = Optional.of(ldpathProgram);
            return this;
        }

        public AnalysisRequestBuilder addDereferencingField(String field) {
            this.request.dereferencedFields.add(field);
            return this;
        }

        public AnalysisRequest build() {
            return this.request;
        }
    }

    private static enum ContentType {
        STRING,
        FILE,
        INPUTSTREAM,
        EMPTY;

    }

    public static enum OutputFormat {
        XML(MediaType.create("application", "xml")),
        JSON(MediaType.create("application", "json")),
        JSONLD(MediaType.create("application", "ld+json")),
        RDFXML(MediaType.create("application", "rdf+xml")),
        RDFJSON(MediaType.create("application", "rdf+json")),
        TURTLE(MediaType.create("text", "turtle")),
        NT(MediaType.create("text", "rdf+n3"));

        private final MediaType type;

        private OutputFormat(MediaType type) {
            this.type = type;
        }

        public MediaType value() {
            return this.type;
        }

        public static OutputFormat get(String type) {
            for (OutputFormat of : OutputFormat.values()) {
                if (!of.type.toString().equals(type)) continue;
                return of;
            }
            return null;
        }
    }

    public static enum InputFormat {
        TEXT(MediaType.create("text", "plain")),
        HTML(MediaType.create("text", "html")),
        PDF(MediaType.create("application", "pdf")),
        OFFICE(MediaType.create("application", "doc")),
        OCTETSTREAM(MediaType.create("application", "octet-stream"));

        private final MediaType type;

        private InputFormat(MediaType type) {
            this.type = type;
        }

        public MediaType value() {
            return this.type;
        }
    }
}

