/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl;

import io.redlink.sdk.impl.AbstractCredentials;
import io.redlink.sdk.util.UriBuilder;
import io.redlink.sdk.util.VersionHelper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StagingCredentials
extends AbstractCredentials {
    private static final long serialVersionUID = 6763770459425653864L;
    public static final String ENDPOINT = "https://api.staging.redlink.io";
    public static final String KEY_PARAM = "key";
    public static final String DATAHUB = "http://data.staging.redlink.io";
    private static Logger log = LoggerFactory.getLogger(StagingCredentials.class);

    public StagingCredentials(String apiKey) {
        this(apiKey, VersionHelper.getApiVersion());
    }

    public StagingCredentials(String apiKey, String version) {
        super(ENDPOINT, version, apiKey, DATAHUB);
        log.debug("created credentials over {}/{}", (Object)ENDPOINT, (Object)version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI buildUrl(UriBuilder builder) throws MalformedURLException, IllegalArgumentException, URISyntaxException {
        UriBuilder uriBuilder = builder;
        synchronized (uriBuilder) {
            return builder.addParameter(KEY_PARAM, this.apiKey).build();
        }
    }
}

