/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailWrapper;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.inferencer.InferencerConnectionWrapper;
import org.openrdf.sail.inferencer.fc.config.CustomGraphQueryInferencerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGraphQueryInferencer
extends NotifyingSailWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ParsedGraphQuery customQuery;
    private ParsedGraphQuery customMatcher;
    private final Collection<Value> watchPredicates = new HashSet<Value>();
    private final Collection<Value> watchSubjects = new HashSet<Value>();
    private final Collection<Value> watchObjects = new HashSet<Value>();
    private boolean hasWatchValues;

    public CustomGraphQueryInferencer() {
    }

    public CustomGraphQueryInferencer(QueryLanguage language, String queryText, String matcherText) throws MalformedQueryException, UnsupportedQueryLanguageException, SailException {
        this.setFields(language, queryText, matcherText);
    }

    public CustomGraphQueryInferencer(NotifyingSail baseSail, QueryLanguage language, String queryText, String matcherText) throws MalformedQueryException, UnsupportedQueryLanguageException, SailException {
        super(baseSail);
        this.setFields(language, queryText, matcherText);
    }

    public final void setFields(QueryLanguage language, String queryText, String matcherText) throws MalformedQueryException, SailException {
        this.customQuery = QueryParserUtil.parseGraphQuery(language, queryText, null);
        String matcherQuery = matcherText;
        if (matcherText.trim().isEmpty()) {
            matcherQuery = CustomGraphQueryInferencerConfig.buildMatcherQueryFromRuleQuery(language, queryText);
        }
        this.customMatcher = QueryParserUtil.parseGraphQuery(language, matcherQuery, null);
        this.customQuery.getTupleExpr().visit(new QueryModelVisitorBase<SailException>(){

            @Override
            public void meet(StatementPattern statement) throws SailException {
                Var var = statement.getSubjectVar();
                if (var.hasValue()) {
                    CustomGraphQueryInferencer.this.watchSubjects.add(var.getValue());
                }
                if ((var = statement.getPredicateVar()).hasValue()) {
                    CustomGraphQueryInferencer.this.watchPredicates.add(var.getValue());
                }
                if ((var = statement.getObjectVar()).hasValue()) {
                    CustomGraphQueryInferencer.this.watchObjects.add(var.getValue());
                }
            }
        });
        this.hasWatchValues = !this.watchSubjects.isEmpty() || !this.watchPredicates.isEmpty() || !this.watchObjects.isEmpty();
    }

    @Override
    public InferencerConnection getConnection() throws SailException {
        try {
            InferencerConnection con = (InferencerConnection)super.getConnection();
            return new Connection(con);
        }
        catch (ClassCastException e) {
            throw new SailException(e.getMessage(), e);
        }
    }

    @Override
    public void initialize() throws SailException {
        super.initialize();
        InferencerConnection con = this.getConnection();
        try {
            con.begin();
            con.flushUpdates();
            con.commit();
        }
        finally {
            con.close();
        }
    }

    public Collection<Value> getWatchSubjects() {
        return Collections.unmodifiableCollection(this.watchSubjects);
    }

    public Collection<Value> getWatchPredicates() {
        return Collections.unmodifiableCollection(this.watchPredicates);
    }

    public Collection<Value> getWatchObjects() {
        return Collections.unmodifiableCollection(this.watchObjects);
    }

    private class Connection
    extends InferencerConnectionWrapper
    implements SailConnectionListener {
        private boolean updateNeeded;

        private Connection(InferencerConnection con) {
            super(con);
            this.updateNeeded = false;
            con.addConnectionListener(this);
        }

        @Override
        public void statementAdded(Statement statement) {
            this.setUpdateNeededIfMatching(statement);
        }

        @Override
        public void statementRemoved(Statement statement) {
            this.setUpdateNeededIfMatching(statement);
        }

        private void setUpdateNeededIfMatching(Statement statement) {
            this.updateNeeded = CustomGraphQueryInferencer.this.hasWatchValues ? CustomGraphQueryInferencer.this.watchPredicates.contains(statement.getPredicate()) || CustomGraphQueryInferencer.this.watchSubjects.contains(statement.getSubject()) || CustomGraphQueryInferencer.this.watchObjects.contains(statement.getObject()) : true;
        }

        @Override
        public void rollback() throws SailException {
            super.rollback();
            this.updateNeeded = false;
        }

        @Override
        public void flushUpdates() throws SailException {
            super.flushUpdates();
            HashSet<Statement> forRemoval = new HashSet<Statement>(256);
            HashSet<Statement> forAddition = new HashSet<Statement>(256);
            Resource[] contexts = new Resource[]{null};
            while (this.updateNeeded) {
                try {
                    forRemoval.clear();
                    forAddition.clear();
                    this.buildDeltaSets(forRemoval, forAddition);
                    for (Statement st : forRemoval) {
                        this.removeInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    for (Statement st : forAddition) {
                        this.addInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    this.updateNeeded = false;
                }
                catch (RDFHandlerException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof SailException) {
                        throw (SailException)cause;
                    }
                    throw new SailException(cause);
                }
                catch (QueryEvaluationException e) {
                    throw new SailException(e);
                }
                super.flushUpdates();
            }
        }

        private void buildDeltaSets(Collection<Statement> forRemoval, Collection<Statement> forAddition) throws SailException, RDFHandlerException, QueryEvaluationException {
            this.evaluateIntoStatements(CustomGraphQueryInferencer.this.customMatcher, forRemoval);
            this.evaluateIntoStatements(CustomGraphQueryInferencer.this.customQuery, forAddition);
            CustomGraphQueryInferencer.this.logger.debug("existing virtual properties: {}", (Object)forRemoval.size());
            CustomGraphQueryInferencer.this.logger.debug("new virtual properties: {}", (Object)forAddition.size());
            HashSet<Statement> inCommon = new HashSet<Statement>(forRemoval);
            inCommon.retainAll(forAddition);
            forRemoval.removeAll(inCommon);
            forAddition.removeAll(inCommon);
            CustomGraphQueryInferencer.this.logger.debug("virtual properties to remove: {}", (Object)forRemoval.size());
            CustomGraphQueryInferencer.this.logger.debug("virtual properties to add: {}", (Object)forAddition.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateIntoStatements(ParsedGraphQuery query, Collection<Statement> statements) throws SailException, RDFHandlerException, QueryEvaluationException {
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter = this.getWrappedConnection().evaluate(query.getTupleExpr(), null, EmptyBindingSet.getInstance(), true);
            try {
                ValueFactory factory = CustomGraphQueryInferencer.this.getValueFactory();
                while (bindingsIter.hasNext()) {
                    BindingSet bindings = (BindingSet)bindingsIter.next();
                    Value subj = bindings.getValue("subject");
                    Value pred = bindings.getValue("predicate");
                    Value obj = bindings.getValue("object");
                    if (!(subj instanceof Resource) || !(pred instanceof URI) || obj == null) continue;
                    statements.add(factory.createStatement((Resource)subj, (URI)pred, obj));
                }
            }
            finally {
                bindingsIter.close();
            }
        }
    }
}

