/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.client.query.AbstractHTTPUpdate;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sparql.query.QueryStringUtil;

public class SPARQLUpdate
extends AbstractHTTPUpdate {
    public SPARQLUpdate(HTTPClient httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    @Override
    public void execute() throws UpdateExecutionException {
        try {
            HTTPClient client = this.getHttpClient();
            try {
                client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getBindingsArray());
            }
            catch (UnauthorizedException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
            catch (QueryInterruptedException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
            catch (MalformedQueryException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
        }
        catch (RepositoryException e) {
            throw new UpdateExecutionException(e.getMessage(), e);
        }
    }

    @Override
    public String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

