/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.sparqlxml;

import info.aduna.io.UncloseableInputStream;
import info.aduna.xml.SimpleSAXParser;
import info.aduna.xml.XMLReaderFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.QueryResultParserBase;
import org.openrdf.query.resultio.sparqlxml.SPARQLBooleanSAXParser;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsSAXParser;
import org.xml.sax.SAXException;

public abstract class SPARQLXMLParserBase
extends QueryResultParserBase {
    public SPARQLXMLParserBase() {
    }

    public SPARQLXMLParserBase(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parseQueryResultInternal(in, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean parseQueryResultInternal(InputStream in, boolean attemptParseBoolean, boolean attemptParseTuple) throws IOException, QueryResultParseException, QueryResultHandlerException {
        if (!attemptParseBoolean && !attemptParseTuple) {
            throw new IllegalArgumentException("Internal error: Did not specify whether to parse as either boolean and/or tuple");
        }
        buff = new BufferedInputStream(in);
        uncloseable = new UncloseableInputStream(buff);
        caughtException = null;
        result = false;
        try {
            if (!attemptParseBoolean) ** GOTO lbl30
            buff.mark(0x7FFFFFFF);
            try {
                valueParser = new SPARQLBooleanSAXParser();
                booleanSAXParser = new SimpleSAXParser(XMLReaderFactory.createXMLReader());
                booleanSAXParser.setListener(valueParser);
                booleanSAXParser.parse(uncloseable);
                result = valueParser.getValue();
                try {
                    if (this.handler != null) {
                        this.handler.handleBoolean(result);
                    }
                }
                catch (QueryResultHandlerException e) {
                    if (e.getCause() != null && e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new QueryResultParseException("Found an issue with the query result handler", e);
                }
                var10_14 = result;
                return var10_14;
            }
            catch (SAXException e) {
                caughtException = e;
                buff.reset();
lbl30:
                // 2 sources

                if (attemptParseTuple) {
                    try {
                        resultsSAXParser = new SimpleSAXParser(XMLReaderFactory.createXMLReader());
                        resultsSAXParser.setPreserveWhitespace(true);
                        resultsSAXParser.setListener(new SPARQLResultsSAXParser(this.valueFactory, this.handler));
                        resultsSAXParser.parse(uncloseable);
                        caughtException = null;
                    }
                    catch (SAXException e) {
                        caughtException = e;
                    }
                }
                if (caughtException != null) {
                    wrappedExc = caughtException.getException();
                    if (wrappedExc == null) {
                        throw new QueryResultParseException(caughtException);
                    }
                    if (wrappedExc instanceof QueryResultParseException) {
                        throw (QueryResultParseException)wrappedExc;
                    }
                    if (wrappedExc instanceof QueryResultHandlerException) {
                        throw (QueryResultHandlerException)wrappedExc;
                    }
                    throw new QueryResultParseException(wrappedExc);
                }
            }
        }
        finally {
            uncloseable.doClose();
        }
        return result;
    }
}

