/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.marmotta.client.exception.ParseException;
import org.apache.marmotta.client.model.meta.Metadata;
import org.apache.marmotta.client.model.rdf.BNode;
import org.apache.marmotta.client.model.rdf.RDFNode;
import org.apache.marmotta.client.model.rdf.URI;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;

public class RDFJSONParser {
    private RDFJSONParser() {
    }

    public static Map<String, Metadata> parseRDFJSON(InputStream data) throws ParseException {
        try {
            Model model = Rio.parse(data, "", RDFFormat.RDFJSON, new Resource[0]);
            HashMap<String, Metadata> result = new HashMap<String, Metadata>();
            for (Resource subject : model.subjects()) {
                Metadata m = new Metadata(subject.stringValue());
                for (org.openrdf.model.URI property : model.filter(subject, null, null, new Resource[0]).predicates()) {
                    HashSet<RDFNode> propValue = new HashSet<RDFNode>();
                    for (Value value : model.filter(subject, property, null, new Resource[0]).objects()) {
                        propValue.add(RDFJSONParser.parseRDFJSONNode(value));
                    }
                    m.put(property.stringValue(), propValue);
                }
                result.put(subject.stringValue(), m);
            }
            return result;
        }
        catch (IOException e) {
            throw new ParseException("could not parse JSON data", e);
        }
        catch (RDFParseException e) {
            throw new ParseException("could not parse JSON data", e);
        }
        catch (UnsupportedRDFormatException e) {
            throw new ParseException("could not parse JSON data", e);
        }
    }

    public static RDFNode parseRDFJSONNode(Map<String, String> nodeDef) {
        RDFNode object = nodeDef.get("type").equals("uri") ? new URI(nodeDef.get("value")) : (nodeDef.get("type").equals("bnode") ? new BNode(nodeDef.get("value")) : (nodeDef.get("lang") != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeDef.get("value"), nodeDef.get("lang")) : (nodeDef.get("datatype") != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeDef.get("value"), new URI(nodeDef.get("datatype"))) : new org.apache.marmotta.client.model.rdf.Literal(nodeDef.get("value")))));
        return object;
    }

    public static RDFNode parseRDFJSONNode(Value value) {
        Literal literal;
        RDFNode object = value instanceof org.openrdf.model.URI ? new URI(value.stringValue()) : (value instanceof BNode ? new BNode(value.stringValue()) : ((literal = (Literal)value).getLanguage() != null ? new org.apache.marmotta.client.model.rdf.Literal(literal.getLabel(), literal.getLanguage()) : (literal.getDatatype() != null ? new org.apache.marmotta.client.model.rdf.Literal(literal.getLabel(), new URI(literal.getDatatype().stringValue())) : new org.apache.marmotta.client.model.rdf.Literal(literal.getLabel()))));
        return object;
    }

    public static void serializeRDFJSON(Map<String, Metadata> data, OutputStream out) throws IOException {
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        LinkedHashModel results = new LinkedHashModel();
        for (Map.Entry<String, Metadata> subject : data.entrySet()) {
            Resource subjectResource = RDFJSONParser.stringToResource(subject.getKey(), vf);
            for (Map.Entry predicate : subject.getValue().entrySet()) {
                org.openrdf.model.URI predicateURI = vf.createURI((String)predicate.getKey());
                for (RDFNode objectNode : (Set)predicate.getValue()) {
                    Value objectValue = objectNode instanceof org.apache.marmotta.client.model.rdf.Literal ? (((org.apache.marmotta.client.model.rdf.Literal)objectNode).getLanguage() != null ? vf.createLiteral(((org.apache.marmotta.client.model.rdf.Literal)objectNode).getContent(), ((org.apache.marmotta.client.model.rdf.Literal)objectNode).getLanguage()) : (((org.apache.marmotta.client.model.rdf.Literal)objectNode).getType() != null ? vf.createLiteral(((org.apache.marmotta.client.model.rdf.Literal)objectNode).getContent(), vf.createURI(((org.apache.marmotta.client.model.rdf.Literal)objectNode).getType().getUri())) : vf.createLiteral(((org.apache.marmotta.client.model.rdf.Literal)objectNode).getContent()))) : (objectNode instanceof URI ? vf.createURI(((URI)objectNode).getUri()) : vf.createBNode(((BNode)objectNode).getAnonId()));
                    results.add(subjectResource, predicateURI, objectValue, new Resource[0]);
                }
            }
        }
        try {
            Rio.write((Iterable<Statement>)results, out, RDFFormat.RDFJSON);
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
    }

    private static Resource stringToResource(String resource, ValueFactory vf) {
        if (resource.startsWith("_:")) {
            return vf.createBNode(resource.substring(2));
        }
        return vf.createURI(resource);
    }
}

