/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.util.MetaUtil;

public class HTTPUtil {
    private static final String CONTEXT = "context";

    public static HttpClient createClient(ClientConfiguration config) {
        return HTTPUtil.createClient(config, config.getMarmottaContext());
    }

    public static HttpClient createClient(ClientConfiguration config, String context) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setUserAgent("Marmotta Client Library/" + MetaUtil.getVersion());
        httpClientBuilder.setRedirectStrategy(new MarmottaRedirectStrategy());
        httpClientBuilder.setRetryHandler(new MarmottaHttpRequestRetryHandler());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setSocketTimeout(config.getSoTimeout());
        requestConfigBuilder.setConnectTimeout(config.getConnectionTimeout());
        requestConfigBuilder.setRedirectsEnabled(true);
        requestConfigBuilder.setMaxRedirects(3);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        if (config.getConectionManager() != null) {
            httpClientBuilder.setConnectionManager(config.getConectionManager());
        } else {
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(100);
            httpClientBuilder.setConnectionManager(cm);
        }
        return httpClientBuilder.build();
    }

    public static HttpPost createPost(String path, ClientConfiguration config) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(config.getMarmottaUri());
        uriBuilder.setPath(uriBuilder.getPath() + path);
        if (StringUtils.isNotBlank(config.getMarmottaContext())) {
            uriBuilder.addParameter(CONTEXT, config.getMarmottaContext());
        }
        HttpPost post = new HttpPost(uriBuilder.build());
        if (StringUtils.isNotBlank(config.getMarmottaUser()) && StringUtils.isNotBlank(config.getMarmottaUser())) {
            String credentials = String.format("%s:%s", config.getMarmottaUser(), config.getMarmottaPassword());
            try {
                String encoded = DatatypeConverter.printBase64Binary((byte[])credentials.getBytes("UTF-8"));
                post.setHeader("Authorization", String.format("Basic %s", encoded));
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Error encoding credentials: " + e.getMessage());
            }
        }
        return post;
    }

    private static class MarmottaHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private MarmottaHttpRequestRetryHandler() {
        }

        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    }

    private static class MarmottaRedirectStrategy
    extends DefaultRedirectStrategy {
        private MarmottaRedirectStrategy() {
        }

        @Override
        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            if (response == null) {
                throw new IllegalArgumentException("HTTP response may not be null");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            String method = request.getRequestLine().getMethod();
            Header locationHeader = response.getFirstHeader("location");
            switch (statusCode) {
                case 302: {
                    return (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD")) && locationHeader != null;
                }
                case 301: 
                case 307: {
                    return method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD");
                }
                case 303: {
                    return true;
                }
                case 300: {
                    return true;
                }
            }
            return false;
        }
    }
}

