/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.util;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return CollectionUtils.toCollection(LinkedList.class, iterable);
    }

    public static <T> Set<T> toSet(Iterable<T> iterable) {
        return CollectionUtils.toCollection(HashSet.class, iterable);
    }

    private static <C extends Collection<T>, T> C toCollection(Class<C> cls, Iterable<T> iterable) {
        try {
            Collection result = (Collection)cls.newInstance();
            for (T item : iterable) {
                result.add(item);
            }
            return (C)result;
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static <T> T first(Iterable<T> iterable) {
        return iterable.iterator().next();
    }

    public static <T> String fold(Collection<T> elements, String separator) {
        StringBuilder builder = new StringBuilder();
        ArrayList<T> list = new ArrayList<T>(elements);
        for (int i = 0; i < list.size(); ++i) {
            builder.append(list.get(i).toString());
            if (i >= list.size() - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> String fold(Collection<T> elements, Format format, String separator) {
        StringBuilder builder = new StringBuilder();
        ArrayList<T> list = new ArrayList<T>(elements);
        for (int i = 0; i < list.size(); ++i) {
            builder.append(format.format(list.get(i)));
            if (i >= list.size() - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> String fold(Collection<T> elements, StringSerializer<T> format, String separator) {
        StringBuilder builder = new StringBuilder();
        ArrayList<T> list = new ArrayList<T>(elements);
        for (int i = 0; i < list.size(); ++i) {
            builder.append(format.serialize(list.get(i)));
            if (i >= list.size() - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> List<T> concat(Collection<? extends Collection<T>> lists) {
        int size = 0;
        for (Collection<T> list : lists) {
            size += list.size();
        }
        ArrayList<T> result = new ArrayList<T>(size);
        for (Collection<T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public static interface StringSerializer<T> {
        public String serialize(T var1);
    }
}

