/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.exception.MarmottaClientException;
import org.apache.marmotta.client.exception.NotFoundException;
import org.apache.marmotta.client.model.config.Configuration;
import org.apache.marmotta.client.util.HTTPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationClient {
    private static Logger log = LoggerFactory.getLogger(ConfigurationClient.class);
    private static final String URL_CONFIG_SERVICE = "/config";
    private ClientConfiguration config;

    public ConfigurationClient(ClientConfiguration config) {
        this.config = config;
    }

    public Set<String> listConfigurationKeys() throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpGet get = new HttpGet(this.config.getMarmottaUri() + URL_CONFIG_SERVICE + "/list");
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse response = httpClient.execute(get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("configurations listed successfully");
                    ObjectMapper mapper = new ObjectMapper();
                    Map result = (Map)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
                    Set<String> set = result.keySet();
                    return set;
                }
            }
            log.error("error retrieving list of configuration keys: {} {}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            throw new MarmottaClientException("error retrieving list of configuration keys: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        finally {
            get.releaseConnection();
        }
    }

    public Set<Configuration> listConfigurations(String prefix) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_CONFIG_SERVICE + "/list" + (prefix != null ? "?prefix=" + URLEncoder.encode(prefix, "utf-8") : "");
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse response = httpClient.execute(get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("configurations listed successfully");
                    ObjectMapper mapper = new ObjectMapper();
                    Map resultMap = (Map)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
                    HashSet<Configuration> result = new HashSet<Configuration>();
                    for (Map.Entry entry : resultMap.entrySet()) {
                        result.add(new Configuration((String)entry.getKey(), ((Map)entry.getValue()).get("value")));
                    }
                    HashSet<Configuration> hashSet = result;
                    return hashSet;
                }
            }
            log.error("error retrieving list of configuration keys: {} {}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            throw new MarmottaClientException("error retrieving list of configuration keys: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        finally {
            get.releaseConnection();
        }
    }

    public Configuration getConfiguration(String key) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_CONFIG_SERVICE + "/data/" + URLEncoder.encode(key, "utf-8");
        HttpGet get = new HttpGet(serviceUrl);
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse response = httpClient.execute(get);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("configuration {} retrieved successfully", (Object)key);
                    ObjectMapper mapper = new ObjectMapper();
                    Map resultMap = (Map)mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    if (resultMap.isEmpty()) {
                        Configuration configuration = null;
                        return configuration;
                    }
                    Configuration configuration = new Configuration(key, resultMap.get(key));
                    return configuration;
                }
                case 404: {
                    log.info("configuration with key {} does not exist", (Object)key);
                    Configuration configuration = null;
                    return configuration;
                }
            }
            log.error("error retrieving configuration {}: {} {}", new Object[]{key, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
            throw new MarmottaClientException("error retrieving configuration " + key + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfiguration(String key, final Object value) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_CONFIG_SERVICE + "/data/" + URLEncoder.encode(key, "utf-8");
        HttpPost post = new HttpPost(serviceUrl);
        post.setHeader("Content-Type", "application/json");
        ContentProducer cp = new ContentProducer(){

            @Override
            public void writeTo(OutputStream outstream) throws IOException {
                ObjectMapper mapper = new ObjectMapper();
                if (value instanceof Collection) {
                    mapper.writeValue(outstream, value);
                } else {
                    mapper.writeValue(outstream, Collections.singletonList(value.toString()));
                }
            }
        };
        post.setEntity(new EntityTemplate(cp));
        try {
            HttpResponse response = httpClient.execute(post);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("configuration {} updated successfully", (Object)key);
                    return;
                }
                case 404: {
                    log.error("configuration with key {} does not exist", (Object)key);
                    throw new NotFoundException("configuration with key " + key + " does not exist");
                }
                default: {
                    log.error("error updating configuration {}: {} {}", new Object[]{key, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                    throw new MarmottaClientException("error updating configuration " + key + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                }
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteConfiguration(String key) throws IOException, MarmottaClientException {
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        String serviceUrl = this.config.getMarmottaUri() + URL_CONFIG_SERVICE + "/data/" + URLEncoder.encode(key, "utf-8");
        HttpDelete delete = new HttpDelete(serviceUrl);
        try {
            HttpResponse response = httpClient.execute(delete);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug("configuration {} deleted successfully", (Object)key);
                    return;
                }
                case 404: {
                    log.error("configuration with key {} does not exist", (Object)key);
                    throw new NotFoundException("configuration with key " + key + " does not exist");
                }
                default: {
                    log.error("error deleting configuration {}: {} {}", new Object[]{key, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                    throw new MarmottaClientException("error deleting configuration " + key + ": " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                }
            }
        }
        finally {
            delete.releaseConnection();
        }
    }
}

