/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis.model;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class Entity {
    private String uri;
    private String dataset;
    private Map<String, Multimap<Optional<String>, String>> properties = Maps.newHashMap();

    public Entity() {
    }

    public Entity(String uri, String dataset) {
        this();
        this.uri = uri;
        this.dataset = dataset;
    }

    public String getUri() {
        return this.uri;
    }

    void setUri(String uri) {
        this.uri = uri;
    }

    public String getDataset() {
        return this.dataset;
    }

    void setDataset(String dataset) {
        this.dataset = dataset;
    }

    void addPropertyValue(String property, String value) {
        if (property != null && value != null) {
            Multimap<Optional<String>, String> entry = this.properties.get(property);
            if (entry == null) {
                entry = HashMultimap.create();
                this.properties.put(property, entry);
            }
            Optional nullable = Optional.absent();
            entry.put(nullable, value);
        }
    }

    void addPropertyValue(String property, String language, String value) {
        if (language == null) {
            this.addPropertyValue(property, value);
        }
        if (property != null && value != null) {
            Multimap<Optional<String>, String> entry = this.properties.get(property);
            if (entry == null) {
                entry = HashMultimap.create();
                this.properties.put(property, entry);
            }
            entry.put(Optional.of(language), value);
        }
    }

    public Collection<String> getValues(String property) {
        Multimap<Optional<String>, String> values = this.properties.get(property);
        if (values == null) {
            return Collections.emptyList();
        }
        return values.values();
    }

    public Multimap<String, String> getValuesByLanguage(String property) {
        HashMultimap<String, String> result = HashMultimap.create();
        if (this.properties.containsKey(property)) {
            Multimap<Optional<String>, String> values = this.properties.get(property);
            for (Map.Entry<Optional<String>, String> entry : values.entries()) {
                if (!entry.getKey().isPresent()) continue;
                result.put(entry.getKey().get(), entry.getValue());
            }
        }
        return result;
    }

    public String getValue(String property, String language) {
        Multimap<Optional<String>, String> values = this.properties.get(property);
        if (values == null) {
            return null;
        }
        Iterator<String> it = values.get(Optional.of(language)).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public Collection<String> getProperties() {
        return this.properties.keySet();
    }

    public String getFirstPropertyValue(String property) {
        Iterator<String> it = this.getValues(property).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

