/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.RedLink;
import io.redlink.sdk.impl.RedLinkClient;
import io.redlink.sdk.impl.Status;
import io.redlink.sdk.util.UriBuilder;
import java.io.IOException;
import java.net.URISyntaxException;

public abstract class RedLinkAbstractImpl
implements RedLink {
    private static final long serialVersionUID = -2644378258418145067L;
    protected final Credentials credentials;
    protected final Status status;
    protected final RedLinkClient client;

    public RedLinkAbstractImpl(Credentials credentials) {
        this.credentials = credentials;
        try {
            this.status = credentials.getStatus();
            if (!this.status.isAccessible()) {
                throw new IllegalArgumentException("invalid credentials: not accessible api key");
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("invalid credentials: " + e.getMessage(), e);
        }
        this.client = new RedLinkClient();
    }

    protected final UriBuilder initiateUriBuilding() throws URISyntaxException {
        return (UriBuilder)new UriBuilder(this.credentials.getEndpoint()).setPath(this.credentials.getVersion());
    }
}

