/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.impl.RedLinkClient;
import io.redlink.sdk.impl.Status;
import io.redlink.sdk.util.UriBuilder;
import java.net.MalformedURLException;
import java.net.URI;

abstract class AbstractCredentials
implements Credentials {
    private static final long serialVersionUID = -3107180751543637209L;
    protected final String endpoint;
    protected final String version;
    protected final String apiKey;
    protected final String datahub;
    protected Status status;
    protected RedLinkClient client;

    AbstractCredentials(String endpoint, String version, String apiKey, String datahub) {
        this.endpoint = endpoint;
        this.version = version;
        this.apiKey = apiKey;
        this.datahub = datahub;
        this.client = new RedLinkClient();
    }

    AbstractCredentials(String endpoint, String version, String apiKey) {
        this(endpoint, version, apiKey, endpoint.replace("api", "data").replace("https://", "http://"));
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getDataHub() {
        return this.datahub;
    }

    @Override
    public boolean verify() throws MalformedURLException {
        if (this.status == null) {
            this.status = this.getStatus();
        }
        return this.status.isAccessible();
    }

    @Override
    public synchronized Status getStatus() {
        try {
            URI target = this.buildUrl(new UriBuilder(this.endpoint).path(this.version));
            return this.client.get(target, Status.class, "application/json");
        }
        catch (Exception e) {
            throw new RuntimeException("Status check failed: " + e.getMessage(), e);
        }
    }
}

