/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class RedLinkClientBuilder
extends ResteasyClientBuilder {
    public static final int DEFAULT_TIMEOUT = 10;

    public RedLinkClientBuilder() {
        this(10L);
    }

    public RedLinkClientBuilder(long timeout) {
        this.establishConnectionTimeout(timeout, TimeUnit.SECONDS);
        this.connectionPoolSize(5);
        SSLContext ctx = null;
        try {
            InputStream fis = ((Object)((Object)this)).getClass().getResourceAsStream("/redlink-CA.crt");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(fis);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyStore.setCertificateEntry("redlink-CA", cert);
            tmf.init(keyStore);
            ctx = SSLContext.getInstance("SSLv3");
            ctx.init(null, tmf.getTrustManagers(), null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
        }
        if (ctx == null) {
            this.disableTrustManager();
        } else {
            this.sslContext(ctx);
        }
    }
}

