/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ApiHelper {
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d)+\\.(\\d)+(\\.\\d+)?\\-([A-Z]+)(\\-SNAPSHOT)?");

    public static String getApiVersion() {
        String version = ApiHelper.getApiVersion(ApiHelper.class.getPackage().getImplementationVersion());
        return StringUtils.isBlank((CharSequence)version) ? "1.0-BETA" : version;
    }

    public static String getApiVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            if (StringUtils.isBlank((CharSequence)matcher.group(4))) {
                return String.format("%s.%s", matcher.group(1), matcher.group(2));
            }
            return String.format("%s.%s-%s", matcher.group(1), matcher.group(2), matcher.group(4));
        }
        return null;
    }
}

