/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.search;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.RedLink;
import io.redlink.sdk.impl.RedLinkAbstractImpl;
import io.redlink.sdk.impl.search.model.SearchResults;
import java.net.MalformedURLException;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;

public class RedLinkSearchImpl
extends RedLinkAbstractImpl
implements RedLink.Search {
    public RedLinkSearchImpl(Credentials credentials) {
        super(credentials);
    }

    @Override
    public SearchResults search(String query, String core) {
        try {
            String service = this.credentials.buildUrl(this.getSearchUriBuilder(query, core)).toString();
            return this.execSearch(service);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SearchResults search(String query, String core, int start, int results, boolean facet) {
        try {
            String service = this.credentials.buildUrl(this.getSearchUriBuilder(query, core, start, results, facet)).toString();
            return this.execSearch(service);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    private final UriBuilder getSearchUriBuilder(String query, String core) {
        return this.initiateUriBuilding().path("search").path(core).queryParam("search", new Object[]{query});
    }

    private final UriBuilder getSearchUriBuilder(String query, String core, int start, int results, boolean facet) {
        return this.getSearchUriBuilder(query, core).queryParam("start", new Object[]{start}).queryParam("results", new Object[]{results}).queryParam("facet", new Object[]{facet});
    }

    private final SearchResults execSearch(String uri) {
        ClientRequest request = new ClientRequest(uri);
        request.accept("application/json");
        try {
            ClientResponse response = request.get(SearchResults.class);
            if (response.getStatus() != 200) {
                throw new RuntimeException("Search failed: HTTP error code " + response.getStatus());
            }
            return (SearchResults)response.getEntity();
        }
        catch (Exception e) {
            throw new RuntimeException("Search failed: " + e.getMessage(), e);
        }
    }
}

