/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.data;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.RedLink;
import io.redlink.sdk.impl.RedLinkAbstractImpl;
import io.redlink.sdk.impl.data.model.LDPathResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.marmotta.client.model.rdf.RDFNode;
import org.apache.marmotta.client.model.sparql.SPARQLResult;
import org.apache.marmotta.client.util.RDFJSONParser;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.query.resultio.helpers.QueryResultCollector;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.ParseErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedLinkDataImpl
extends RedLinkAbstractImpl
implements RedLink.Data {
    private static Logger log = LoggerFactory.getLogger(RedLinkDataImpl.class);

    public RedLinkDataImpl(Credentials credentials) {
        super(credentials);
    }

    @Override
    public boolean importDataset(Model data, String dataset) throws IOException, RDFHandlerException {
        return this.importDataset(data, dataset, false);
    }

    @Override
    public boolean importDataset(Model data, String dataset, boolean cleanBefore) throws RDFHandlerException, IOException {
        RDFFormat format = RDFFormat.TURTLE;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Rio.write((Iterable)data, (OutputStream)out, (RDFFormat)format);
        return this.importDataset(new ByteArrayInputStream(out.toByteArray()), format, dataset, cleanBefore);
    }

    @Override
    public boolean importDataset(File file, String dataset) throws FileNotFoundException {
        return this.importDataset(file, dataset, false);
    }

    @Override
    public boolean importDataset(File file, String dataset, boolean cleanBefore) throws FileNotFoundException {
        return this.importDataset(new FileInputStream(file), RDFFormat.forFileName((String)file.getAbsolutePath()), dataset, cleanBefore);
    }

    @Override
    public boolean importDataset(InputStream in, RDFFormat format, String dataset) {
        return this.importDataset(in, format, dataset, false);
    }

    @Override
    public boolean importDataset(InputStream in, RDFFormat format, String dataset, boolean cleanBefore) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getDatasetUriBuilder(dataset));
            Invocation.Builder request = target.request();
            log.debug("Importing {} data into dataset {}", (Object)format.getName(), (Object)dataset);
            Response response = cleanBefore ? request.put(Entity.entity((Object)in, (MediaType)MediaType.valueOf((String)format.getDefaultMIMEType()))) : request.post(Entity.entity((Object)in, (MediaType)MediaType.valueOf((String)format.getDefaultMIMEType())));
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
            return response.getStatus() == 200;
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Model exportDataset(String dataset) {
        RDFFormat format = RDFFormat.TURTLE;
        try {
            WebTarget target = this.credentials.buildUrl(this.getDatasetUriBuilder(dataset));
            Invocation.Builder request = target.request();
            request.header("Accept", (Object)format.getDefaultMIMEType());
            log.debug("Exporting {} data from dataset {}", (Object)format.getName(), (Object)dataset);
            Response response = request.get();
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
            if (response.getStatus() == 200) {
                ParserConfig config = new ParserConfig();
                String entity = (String)response.readEntity(String.class);
                return Rio.parse((Reader)new StringReader(entity), (String)target.getUri().toString(), (RDFFormat)format, (ParserConfig)config, (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
            }
            log.error("Unexpected error exporting dataset {}: request returned with {} status code", (Object)dataset, (Object)response.getStatus());
            throw new RuntimeException("Unexpected error exporting dataset");
        }
        catch (IOException | IllegalArgumentException | UriBuilderException | RDFParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean cleanDataset(String dataset) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getDatasetUriBuilder(dataset));
            Invocation.Builder request = target.request();
            log.debug("Cleaning data from dataset {}", (Object)dataset);
            Response response = request.delete();
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
            return response.getStatus() == 200;
        }
        catch (IOException | IllegalArgumentException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Model getResource(String resource) {
        return this.getResource(this.getResourceUriBuilder(resource));
    }

    @Override
    public Model getResource(String resource, String dataset) {
        return this.getResource(this.getResourceUriBuilder(dataset, resource));
    }

    private Model getResource(UriBuilder uriBuilder) {
        RDFFormat format = RDFFormat.TURTLE;
        try {
            WebTarget target = this.credentials.buildUrl(uriBuilder);
            Invocation.Builder request = target.request();
            request.header("Accept", (Object)format.getDefaultMIMEType());
            log.debug("Retrieving resource as {}", (Object)format.getName());
            Response response = request.get();
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
            if (response.getStatus() == 200) {
                ParserConfig config = new ParserConfig();
                String entity = (String)response.readEntity(String.class);
                return Rio.parse((Reader)new StringReader(entity), (String)target.getUri().toString(), (RDFFormat)format, (ParserConfig)config, (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
            }
            if (response.getStatus() == 404) {
                log.error("resource not found");
                return new TreeModel();
            }
            log.error("Unexpected error retrieving resource: request returned with {} status code", (Object)response.getStatus());
            throw new RuntimeException("Unexpected error retrieving resource");
        }
        catch (IOException | IllegalArgumentException | UriBuilderException | RDFParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean importResource(String resource, Model data, String dataset) {
        return this.importResource(resource, data, dataset, false);
    }

    @Override
    public boolean importResource(String resource, Model data, String dataset, boolean cleanBefore) {
        RDFFormat format = RDFFormat.TURTLE;
        try {
            WebTarget target = this.credentials.buildUrl(this.getResourceUriBuilder(dataset, resource));
            Invocation.Builder request = target.request();
            log.debug("Importing resource {} into dataset {}", (Object)resource, (Object)dataset);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Rio.write((Iterable)data, (OutputStream)out, (RDFFormat)format);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Response response = cleanBefore ? request.put(Entity.entity((Object)in, (MediaType)MediaType.valueOf((String)format.getDefaultMIMEType()))) : request.post(Entity.entity((Object)in, (MediaType)MediaType.valueOf((String)format.getDefaultMIMEType())));
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
            return response.getStatus() == 200;
        }
        catch (IOException | IllegalArgumentException | UriBuilderException | RDFHandlerException e) {
            log.error("Error importing resource: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean deleteResource(String resource, String dataset) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getResourceUriBuilder(dataset, resource));
            Invocation.Builder request = target.request();
            log.debug("Deleting resource {} from datataset {}", (Object)resource, (Object)dataset);
            Response response = request.delete();
            log.debug("Request resolved with {} status code: {}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
            return response.getStatus() == 200;
        }
        catch (IOException | IllegalArgumentException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SPARQLResult sparqlTupleQuery(String query) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder());
            return this.execTupleQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public SPARQLResult sparqlSelect(String query) {
        return this.sparqlTupleQuery(query);
    }

    @Override
    public SPARQLResult sparqlTupleQuery(String query, String dataset) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder(dataset));
            return this.execTupleQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public SPARQLResult sparqlSelect(String query, String dataset) {
        return this.sparqlTupleQuery(query, dataset);
    }

    @Override
    public Model sparqlGraphQuery(String query) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder());
            return this.execGraphQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Model sparqlGraphQuery(String query, String dataset) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getSparqlSelectUriBuilder(dataset));
            return this.execGraphQuery(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean sparqlUpdate(String query, String dataset) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getSparqlUpdateUriBuilder(dataset));
            return this.execUpdate(target, query);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LDPathResult ldpath(String uri, String dataset, String program) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getLDPathUriBuilder(dataset, uri));
            return this.execLDPath(target, uri, program);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LDPathResult ldpath(String uri, String program) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getLDPathUriBuilder(uri));
            return this.execLDPath(target, uri, program);
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    private LDPathResult execLDPath(WebTarget target, String uri, String program) {
        Invocation.Builder request = target.request();
        request.accept(new String[]{"application/json"});
        try {
            log.debug("Executing LDpath program over resource {}", (Object)uri);
            Response response = request.post(Entity.text((Object)program));
            log.debug("Request resolved with {} status code", (Object)response.getStatus());
            if (response.getStatus() != 200) {
                throw new RuntimeException("Query failed: HTTP error code " + response.getStatus());
            }
            LDPathResult result = new LDPathResult();
            Map fields = (Map)response.readEntity(Map.class);
            for (Map.Entry field : fields.entrySet()) {
                ArrayList<RDFNode> row = new ArrayList<RDFNode>();
                for (Map node : (List)field.getValue()) {
                    row.add(RDFJSONParser.parseRDFJSONNode((Map)node));
                }
                result.add((String)field.getKey(), row);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Query execution failed: " + e.getMessage(), e);
        }
    }

    private final UriBuilder getDatasetUriBuilder(String dataset) {
        return this.initiateUriBuilding().path("data").path(dataset);
    }

    private final UriBuilder getResourceUriBuilder(String resource) {
        return this.initiateUriBuilding().path("data").path("resource").queryParam("uri", new Object[]{resource});
    }

    private final UriBuilder getResourceUriBuilder(String dataset, String resource) {
        return this.initiateUriBuilding().path("data").path(dataset).path("resource").queryParam("uri", new Object[]{resource});
    }

    private final UriBuilder getSparqlSelectUriBuilder() {
        return this.initiateUriBuilding().path("data").path("sparql");
    }

    private final UriBuilder getSparqlSelectUriBuilder(String dataset) {
        return this.getDatasetUriBuilder(dataset).path("sparql").path("select");
    }

    private final UriBuilder getSparqlUpdateUriBuilder(String dataset) {
        return this.getDatasetUriBuilder(dataset).path("sparql").path("update");
    }

    private final UriBuilder getLDPathUriBuilder(String uri) {
        return this.initiateUriBuilding().path("data").path("ldpath").queryParam("uri", new Object[]{uri});
    }

    private final UriBuilder getLDPathUriBuilder(String dataset, String uri) {
        return this.initiateUriBuilding().path("data").path(dataset).path("ldpath").queryParam("uri", new Object[]{uri});
    }

    private SPARQLResult execTupleQuery(WebTarget target, String query) {
        Invocation.Builder request = target.request();
        TupleQueryResultFormat format = TupleQueryResultFormat.JSON;
        request.accept(new String[]{format.getDefaultMIMEType()});
        try {
            log.debug("Executing SPARQL tuple query: {}", (Object)query.replaceAll("\\s*[\\r\\n]+\\s*", " ").trim());
            Response response = request.post(Entity.text((Object)query));
            log.debug("Request resolved with {} status code", (Object)response.getStatus());
            if (response.getStatus() != 200) {
                throw new RuntimeException("Query failed: HTTP error code " + response.getStatus());
            }
            QueryResultCollector results = new QueryResultCollector();
            this.parse((String)response.readEntity(String.class), format, (QueryResultHandler)results, (ValueFactory)ValueFactoryImpl.getInstance());
            if (!results.getHandledTuple() || results.getBindingSets().isEmpty()) {
                return new SPARQLResult(new LinkedHashSet());
            }
            List fieldNames = results.getBindingNames();
            SPARQLResult result = new SPARQLResult(new LinkedHashSet(fieldNames));
            for (BindingSet nextRow : results.getBindingSets()) {
                HashMap<String, org.apache.marmotta.client.model.rdf.URI> row = new HashMap<String, org.apache.marmotta.client.model.rdf.URI>();
                for (String nextBindingName : fieldNames) {
                    if (!nextRow.hasBinding(nextBindingName)) continue;
                    Binding nextBinding = nextRow.getBinding(nextBindingName);
                    Value nodeDef = nextBinding.getValue();
                    org.apache.marmotta.client.model.rdf.URI node = null;
                    if (nodeDef instanceof URI) {
                        node = new org.apache.marmotta.client.model.rdf.URI(nodeDef.stringValue());
                    } else if (nodeDef instanceof BNode) {
                        node = new org.apache.marmotta.client.model.rdf.BNode(((BNode)nodeDef).getID());
                    } else if (nodeDef instanceof Literal) {
                        Literal nodeLiteral = (Literal)nodeDef;
                        node = nodeLiteral.getLanguage() != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel(), nodeLiteral.getLanguage()) : (nodeLiteral.getDatatype() != null ? new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel(), new org.apache.marmotta.client.model.rdf.URI(nodeLiteral.getDatatype().stringValue())) : new org.apache.marmotta.client.model.rdf.Literal(nodeLiteral.getLabel()));
                    }
                    if (node == null) continue;
                    row.put(nextBindingName, node);
                }
                result.add(row);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Query execution failed: " + e.getMessage(), e);
        }
    }

    private Model execGraphQuery(WebTarget target, String query) {
        Invocation.Builder request = target.request();
        RDFFormat format = RDFFormat.TURTLE;
        request.accept(new String[]{format.getDefaultMIMEType()});
        try {
            log.debug("Executing SPARQL graph query: {}", (Object)query.replaceAll("\\s*[\\r\\n]+\\s*", " ").trim());
            Response response = request.post(Entity.text((Object)query));
            log.debug("Request resolved with {} status code", (Object)response.getStatus());
            if (response.getStatus() != 200) {
                throw new RuntimeException("Query failed: HTTP error code " + response.getStatus());
            }
            ParserConfig config = new ParserConfig();
            String entity = (String)response.readEntity(String.class);
            return Rio.parse((Reader)new StringReader(entity), (String)target.getUri().toString(), (RDFFormat)format, (ParserConfig)config, (ValueFactory)ValueFactoryImpl.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Query execution failed: " + e.getMessage(), e);
        }
    }

    private boolean execUpdate(WebTarget target, String query) {
        Invocation.Builder request = target.request();
        try {
            log.debug("Executing SPARQL update query: {}", (Object)query.replaceAll("\\s*[\\r\\n]+\\s*", " ").trim());
            Response response = request.post(Entity.entity((Object)query, (MediaType)new MediaType("application", "sparql-update")));
            log.debug("Request resolved with {} status code", (Object)response.getStatus());
            return response.getStatus() == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Query execution failed: " + e.getMessage(), e);
        }
    }

    private void parse(InputStream in, TupleQueryResultFormat format, QueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, QueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler(handler);
        parser.parseQueryResult(in);
    }

    private void parse(String str, TupleQueryResultFormat format, QueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, QueryResultHandlerException, UnsupportedQueryResultFormatException {
        this.parse(new ByteArrayInputStream(str.getBytes("UTF-8")), format, handler, valueFactory);
    }
}

