/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis.model;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.redlink.sdk.impl.analysis.model.Enhancement;
import io.redlink.sdk.impl.analysis.model.EnhancementParserException;
import io.redlink.sdk.impl.analysis.model.EnhancementsParser;
import io.redlink.sdk.impl.analysis.model.Entity;
import io.redlink.sdk.impl.analysis.model.EntityAnnotation;
import io.redlink.sdk.impl.analysis.model.TextAnnotation;
import io.redlink.sdk.impl.analysis.model.TopicAnnotation;
import io.redlink.sdk.util.ModelRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.DCTERMS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

final class RDFStructureParser
extends EnhancementsParser {
    private Repository repository;

    public RDFStructureParser(Model model) throws EnhancementParserException {
        try {
            this.repository = ModelRepository.create(model);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("There was an error initializing the Enhancement Parser", e);
        }
    }

    public RDFStructureParser(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> parseLanguages() throws EnhancementParserException {
        HashSet languages = Sets.newHashSet();
        String textAnnotationsQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nPREFIX dct: <http://purl.org/dc/terms/> \nSELECT * { \n  ?annotation a fise:TextAnnotation . \n  ?annotation dct:type <" + DCTERMS.LINGUISTIC_SYSTEM + "> . \n" + "  ?annotation dct:language ?language . \n" + "} \n";
        try (RepositoryConnection conn = this.repository.getConnection();){
            conn.begin();
            TupleQueryResult textAnnotationsResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, textAnnotationsQuery).evaluate();
            while (textAnnotationsResults.hasNext()) {
                BindingSet result = (BindingSet)textAnnotationsResults.next();
                if (!result.hasBinding("language")) continue;
                languages.add(result.getBinding("language").getValue().stringValue());
            }
            conn.commit();
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing text annotations", e);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
        return languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Enhancement> parseEnhancements() throws EnhancementParserException {
        ArrayListMultimap relations = ArrayListMultimap.create();
        HashMap enhancementsByUri = Maps.newHashMap();
        try (RepositoryConnection conn = this.repository.getConnection();){
            conn.begin();
            this.parseTextAnnotations(conn, (Multimap<Enhancement, String>)relations, enhancementsByUri);
            this.parseEntityAnnotations(conn, (Multimap<Enhancement, String>)relations, enhancementsByUri);
            for (Enhancement e : relations.keys()) {
                Collection relationsUris = relations.get((Object)e);
                HashSet relationsEnhans = Sets.newHashSet();
                for (String uri : relationsUris) {
                    relationsEnhans.add(enhancementsByUri.get(uri));
                }
                e.setRelations(relationsEnhans);
            }
            conn.commit();
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
        return enhancementsByUri.values();
    }

    @Override
    public Collection<TextAnnotation> parseTextAnnotations() throws EnhancementParserException {
        ArrayListMultimap relations = ArrayListMultimap.create();
        HashMap enhancementsByUri = Maps.newHashMap();
        try {
            RepositoryConnection conn = this.repository.getConnection();
            conn.begin();
            Collection<TextAnnotation> tas = this.parseTextAnnotations(conn, (Multimap<Enhancement, String>)relations, enhancementsByUri);
            Collection<Enhancement> result = this.resolveRelations((Multimap<Enhancement, String>)relations, conn);
            for (TextAnnotation ta : tas) {
                if (result.contains(ta)) continue;
                result.add(ta);
            }
            conn.close();
            return result;
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
    }

    private Collection<TextAnnotation> parseTextAnnotations(RepositoryConnection conn, Multimap<Enhancement, String> relations, Map<String, Enhancement> enhancementsByUri) throws EnhancementParserException {
        HashSet tas = Sets.newHashSet();
        String textAnnotationsQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nPREFIX dct: <http://purl.org/dc/terms/> \nSELECT * { \n  ?annotation a fise:TextAnnotation . \n\t OPTIONAL { ?annotation fise:confidence ?confidence } \n  OPTIONAL { ?annotation dct:type ?type} \n  OPTIONAL { ?annotation dct:language ?language} \n  OPTIONAL { ?annotation fise:start ?start ; fise:end ?end } \n  OPTIONAL { ?annotation dct:relation ?relation } \n  OPTIONAL { ?annotation fise:selection-context ?selectionContext } \n  OPTIONAL { ?annotation fise:selected-text ?selectedText } \n} \n";
        try {
            TupleQueryResult textAnnotationsResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, textAnnotationsQuery).evaluate();
            while (textAnnotationsResults.hasNext()) {
                BindingSet result = (BindingSet)textAnnotationsResults.next();
                if (result.hasBinding("type") && result.getBinding("type").getValue().stringValue().equalsIgnoreCase(DCTERMS.LINGUISTIC_SYSTEM.stringValue())) continue;
                String uri = result.getBinding("annotation").getValue().stringValue();
                Enhancement textAnnotation = enhancementsByUri.get(uri);
                if (textAnnotation == null) {
                    textAnnotation = new TextAnnotation();
                    enhancementsByUri.put(uri, textAnnotation);
                }
                this.setTextAnnotationData((TextAnnotation)textAnnotation, result, relations);
                if (tas.contains(textAnnotation)) continue;
                tas.add((TextAnnotation)textAnnotation);
            }
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing text annotations", e);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
        return tas;
    }

    private void setTextAnnotationData(TextAnnotation textAnnotation, BindingSet result, Multimap<Enhancement, String> relations) throws RepositoryException {
        if (!relations.containsKey((Object)textAnnotation)) {
            this.setEnhancementData(textAnnotation, result);
            if (result.hasBinding("start")) {
                textAnnotation.setStarts(Integer.parseInt(result.getBinding("start").getValue().stringValue()));
                textAnnotation.setEnds(Integer.parseInt(result.getBinding("end").getValue().stringValue()));
            }
            if (result.hasBinding("relation")) {
                String nextRelationUri = result.getBinding("relation").getValue().stringValue();
                relations.put((Object)textAnnotation, (Object)nextRelationUri);
            }
            if (result.hasBinding("selectionContext")) {
                textAnnotation.setSelectionContext(result.getBinding("selectionContext").getValue().stringValue());
            }
            if (result.hasBinding("selectedText")) {
                Binding selectedText = result.getBinding("selectedText");
                textAnnotation.setSelectedText(selectedText.getValue().stringValue());
                if (!result.hasBinding("language") && selectedText.getValue() instanceof Literal) {
                    textAnnotation.setLanguage(((Literal)selectedText.getValue()).getLanguage());
                }
            }
        } else if (result.hasBinding("relation")) {
            String nextRelationUri = result.getBinding("relation").getValue().stringValue();
            relations.put((Object)textAnnotation, (Object)nextRelationUri);
        }
    }

    @Override
    public Collection<EntityAnnotation> parseEntityAnnotations() throws EnhancementParserException {
        ArrayListMultimap relations = ArrayListMultimap.create();
        HashMap enhancementsByUri = Maps.newHashMap();
        try {
            RepositoryConnection conn = this.repository.getConnection();
            conn.begin();
            Collection<EntityAnnotation> eas = this.parseEntityAnnotations(conn, (Multimap<Enhancement, String>)relations, enhancementsByUri);
            Collection<Enhancement> result = this.resolveRelations((Multimap<Enhancement, String>)relations, conn);
            for (EntityAnnotation ea : eas) {
                if (result.contains(ea)) continue;
                result.add(ea);
            }
            conn.close();
            return result;
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
    }

    private Collection<EntityAnnotation> parseEntityAnnotations(RepositoryConnection conn, Multimap<Enhancement, String> relations, Map<String, Enhancement> enhancementsByUri) throws EnhancementParserException {
        HashSet eas = Sets.newHashSet();
        String entityAnnotationsQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nPREFIX dct: <http://purl.org/dc/terms/> \nPREFIX entityhub: <http://stanbol.apache.org/ontology/entityhub/entityhub#> \nSELECT * { \n  ?annotation a fise:EntityAnnotation . \n\t OPTIONAL { ?annotation fise:confidence ?confidence } \n  OPTIONAL { ?language a dct:language  } \n  OPTIONAL { ?annotation dct:relation ?relation } \n  OPTIONAL { ?annotation fise:entity-label ?entityLabel } \n  OPTIONAL { ?annotation fise:entity-reference ?entityReference } \n  OPTIONAL { ?annotation fise:entity-type ?entityType } \n  OPTIONAL { ?annotation entityhub:site ?site } \n}";
        try {
            TupleQueryResult entityAnnotationsResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, entityAnnotationsQuery).evaluate();
            while (entityAnnotationsResults.hasNext()) {
                BindingSet result = (BindingSet)entityAnnotationsResults.next();
                String uri = result.getBinding("annotation").getValue().stringValue();
                Enhancement entityAnnotation = enhancementsByUri.get(uri);
                if (entityAnnotation == null) {
                    entityAnnotation = new EntityAnnotation();
                    enhancementsByUri.put(uri, entityAnnotation);
                }
                this.setEntityAnnotationData((EntityAnnotation)entityAnnotation, result, conn, relations);
                if (eas.contains(entityAnnotation)) continue;
                eas.add((EntityAnnotation)entityAnnotation);
            }
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing text annotations", e);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
        return eas;
    }

    private void setEntityAnnotationData(EntityAnnotation entityAnnotation, BindingSet result, RepositoryConnection conn, Multimap<Enhancement, String> relations) throws RepositoryException, EnhancementParserException {
        if (!relations.containsKey((Object)entityAnnotation)) {
            this.setEnhancementData(entityAnnotation, result);
            if (result.hasBinding("entityLabel")) {
                Binding entityLabel = result.getBinding("entityLabel");
                entityAnnotation.setEntityLabel(entityLabel.getValue().stringValue());
                if (!result.hasBinding("language") && entityLabel.getValue() instanceof Literal) {
                    entityAnnotation.setLanguage(((Literal)entityLabel.getValue()).getLanguage());
                }
            }
            if (result.hasBinding("site")) {
                entityAnnotation.setDataset(result.getBinding("site").getValue().stringValue());
            }
            if (result.hasBinding("entityReference")) {
                entityAnnotation.setEntityReference(this.parseEntity(conn, result.getBinding("entityReference").getValue().stringValue(), entityAnnotation.getDataset()));
            }
            if (result.hasBinding("relation")) {
                String nextRelationUri = result.getBinding("relation").getValue().stringValue();
                relations.put((Object)entityAnnotation, (Object)nextRelationUri);
            }
            HashSet<String> types = new HashSet<String>();
            if (result.hasBinding("entityType")) {
                types.add(result.getBinding("entityType").getValue().stringValue());
            }
            entityAnnotation.setEntityTypes(types);
        } else {
            String nextRelationUri;
            if (result.hasBinding("relation") && !relations.containsEntry((Object)entityAnnotation, (Object)(nextRelationUri = result.getBinding("relation").getValue().stringValue()))) {
                relations.put((Object)entityAnnotation, (Object)nextRelationUri);
            }
            if (result.hasBinding("entityType")) {
                final String entityType = result.getBinding("entityType").getValue().stringValue();
                Collection<String> types = entityAnnotation.getEntityTypes();
                Optional eType = Iterables.tryFind(types, (Predicate)new Predicate<String>(){

                    public boolean apply(String arg0) {
                        return arg0.equals(entityType);
                    }
                });
                if (!eType.isPresent()) {
                    types.add(entityType);
                }
            }
        }
    }

    private Collection<Enhancement> resolveRelations(Multimap<Enhancement, String> relations, RepositoryConnection conn) throws EnhancementParserException {
        LinkedList<String> toParse = new LinkedList<String>();
        toParse.addAll(Sets.newHashSet((Iterable)relations.values()));
        HashMap<String, Enhancement> allRelations = new HashMap<String, Enhancement>();
        Multiset initialEnhancements = relations.keys();
        while (!toParse.isEmpty()) {
            String nextRelation = (String)toParse.poll();
            Enhancement nextEnhancement = this.parseEnhancement(nextRelation, conn, toParse, relations);
            if (nextEnhancement == null) continue;
            allRelations.put(nextRelation, nextEnhancement);
        }
        for (Enhancement e : relations.keys()) {
            Collection relationsUris = relations.get((Object)e);
            HashSet nextRelEnhancements = Sets.newHashSet();
            for (String uri : relationsUris) {
                if (uri == null) continue;
                nextRelEnhancements.add(allRelations.get(uri));
            }
            e.setRelations(nextRelEnhancements);
        }
        return initialEnhancements;
    }

    private Enhancement parseEnhancement(String nextRelation, RepositoryConnection conn, Queue<String> toParse, Multimap<Enhancement, String> relations) throws EnhancementParserException {
        String enhancementQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nSELECT * { \n  <" + nextRelation + "> a fise:EntityAnnotation ; \n" + "}";
        Enhancement enhancement = null;
        try {
            TupleQueryResult enhancementResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, enhancementQuery).evaluate();
            enhancement = enhancementResults.hasNext() ? this.parseEntityAnnotation(nextRelation, conn, toParse, relations) : this.parseTextAnnotation(nextRelation, conn, toParse, relations);
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing enhancement " + nextRelation, e);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error parsing Enhancement Type for URI" + nextRelation, e);
        }
        return enhancement;
    }

    private Enhancement parseTextAnnotation(String taUri, RepositoryConnection conn, Queue<String> toParse, Multimap<Enhancement, String> relations) throws RepositoryException, EnhancementParserException {
        TextAnnotation enhancement = new TextAnnotation();
        String textAnnotationQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nPREFIX dct: <http://purl.org/dc/terms/> \nPREFIX entityhub: <http://stanbol.apache.org/ontology/entityhub/entityhub#> \nSELECT * { \n OPTIONAL { <" + taUri + ">  fise:confidence ?confidence } \n" + "  OPTIONAL { <" + taUri + ">  dct:language ?language } \n" + "  OPTIONAL { <" + taUri + "> fise:start ?start ; fise:end ?end } \n" + "  OPTIONAL { <" + taUri + "> dct:type ?type } \n" + "  OPTIONAL { <" + taUri + "> dct:relation ?relation } \n" + "  OPTIONAL { <" + taUri + "> fise:selection-context ?selectionContext } \n" + "  OPTIONAL { <" + taUri + "> fise:selected-text ?selectedText } \n" + "}";
        try {
            TupleQueryResult textAnnotationResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, textAnnotationQuery).evaluate();
            while (textAnnotationResults.hasNext()) {
                String nextRelationUri;
                BindingSet result = (BindingSet)textAnnotationResults.next();
                int i = 0;
                if (i == 0) {
                    this.setEnhancementData(enhancement, result);
                    if (result.hasBinding("start")) {
                        enhancement.setStarts(Integer.parseInt(result.getBinding("start").getValue().stringValue()));
                        enhancement.setEnds(Integer.parseInt(result.getBinding("end").getValue().stringValue()));
                    }
                    if (result.hasBinding("relation")) {
                        nextRelationUri = result.getBinding("relation").getValue().stringValue();
                        if (!relations.values().contains(nextRelationUri)) {
                            toParse.add(nextRelationUri);
                        }
                        relations.put((Object)enhancement, (Object)nextRelationUri);
                    }
                    if (result.hasBinding("selectionContext")) {
                        enhancement.setSelectionContext(result.getBinding("selectionContext").getValue().stringValue());
                    }
                    if (result.hasBinding("selectedText")) {
                        Binding selectedText = result.getBinding("selectedText");
                        enhancement.setSelectedText(selectedText.getValue().stringValue());
                        if (!result.hasBinding("language") && selectedText.getValue() instanceof Literal) {
                            enhancement.setLanguage(((Literal)selectedText.getValue()).getLanguage());
                        }
                    }
                } else if (result.hasBinding("relation")) {
                    nextRelationUri = result.getBinding("relation").getValue().stringValue();
                    if (!relations.values().contains(nextRelationUri)) {
                        toParse.add(nextRelationUri);
                    }
                    relations.put((Object)enhancement, (Object)nextRelationUri);
                }
                ++i;
            }
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing text annotation with URI: " + taUri, e);
        }
        return enhancement;
    }

    private EntityAnnotation parseEntityAnnotation(String eaUri, RepositoryConnection conn, Queue<String> toParse, Multimap<Enhancement, String> relations) throws RepositoryException, EnhancementParserException {
        EntityAnnotation enhancement = new EntityAnnotation();
        String entityAnnotationsQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nPREFIX dct: <http://purl.org/dc/terms/> \nPREFIX entityhub: <http://stanbol.apache.org/ontology/entityhub/entityhub#> \nSELECT * { \n OPTIONAL { <" + eaUri + ">  fise:confidence ?confidence ; \n" + eaUri + ">  dct:language ?language . \n" + "  OPTIONAL { <" + eaUri + "> dct:relation ?relation } \n" + "  OPTIONAL { <" + eaUri + "> fise:entity-label ?entityLabel } \n" + "  OPTIONAL { <" + eaUri + "> fise:entity-reference ?entityReference } \n" + "  OPTIONAL { <" + eaUri + "> fise:entity-type ?entityType } \n" + "  OPTIONAL { <" + eaUri + "> entityhub:site ?site } \n" + "}";
        try {
            TupleQueryResult entityAnnotationsResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, entityAnnotationsQuery).evaluate();
            int i = 0;
            while (entityAnnotationsResults.hasNext()) {
                String nextRelationUri;
                BindingSet result = (BindingSet)entityAnnotationsResults.next();
                if (i == 0) {
                    this.setEnhancementData(enhancement, result);
                    if (result.hasBinding("entityLabel")) {
                        Binding entityLabel = result.getBinding("entityLabel");
                        enhancement.setEntityLabel(entityLabel.getValue().stringValue());
                        if (!result.hasBinding("language") && entityLabel.getValue() instanceof Literal) {
                            enhancement.setLanguage(((Literal)entityLabel.getValue()).getLanguage());
                        }
                    }
                    if (result.hasBinding("site")) {
                        enhancement.setDataset(result.getBinding("site").getValue().stringValue());
                    }
                    if (result.hasBinding("entityReference")) {
                        enhancement.setEntityReference(this.parseEntity(conn, result.getBinding("entityReference").getValue().stringValue(), enhancement.getDataset()));
                    }
                    if (result.hasBinding("relation")) {
                        nextRelationUri = result.getBinding("relation").getValue().stringValue();
                        if (!relations.values().contains(nextRelationUri)) {
                            toParse.add(nextRelationUri);
                        }
                        relations.put((Object)enhancement, (Object)nextRelationUri);
                    }
                    if (result.hasBinding("entityType")) {
                        HashSet<String> types = new HashSet<String>();
                        types.add(result.getBinding("entityType").getValue().stringValue());
                        enhancement.setEntityTypes(types);
                    }
                } else {
                    if (result.hasBinding("relation")) {
                        nextRelationUri = result.getBinding("relation").getValue().stringValue();
                        Collection eRelations = relations.get((Object)enhancement);
                        if (!eRelations.contains(nextRelationUri)) {
                            if (!relations.values().contains(nextRelationUri)) {
                                toParse.add(nextRelationUri);
                            }
                            relations.put((Object)enhancement, (Object)nextRelationUri);
                        }
                    }
                    if (result.hasBinding("entityType")) {
                        String nextType = result.getBinding("entityType").getValue().stringValue();
                        if (!enhancement.getEntityTypes().contains(nextType)) {
                            enhancement.getEntityTypes().add(nextType);
                        }
                    }
                }
                ++i;
            }
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing entity annotation with URI: " + eaUri, e);
        }
        return enhancement;
    }

    @Override
    public Entity parseEntity(String entityUri, String dataset) throws EnhancementParserException {
        try {
            RepositoryConnection conn = this.repository.getConnection();
            conn.begin();
            Entity result = this.parseEntity(conn, entityUri, dataset);
            conn.close();
            return result;
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
    }

    private Entity parseEntity(RepositoryConnection conn, String entityUri, String dataset) throws EnhancementParserException {
        String entityQuery = "SELECT ?p ?o { \n  <" + entityUri + "> ?p ?o ; \n" + "}";
        Entity entity = new Entity(entityUri, dataset);
        try {
            TupleQueryResult entityResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, entityQuery).evaluate();
            while (entityResults.hasNext()) {
                BindingSet result = (BindingSet)entityResults.next();
                Value object = result.getBinding("o").getValue();
                if (object instanceof LiteralImpl) {
                    String language = ((LiteralImpl)object).getLanguage();
                    if (language == null) {
                        entity.addPropertyValue(result.getBinding("p").getValue().stringValue(), object.stringValue());
                        continue;
                    }
                    entity.addPropertyValue(result.getBinding("p").getValue().stringValue(), language, object.stringValue());
                    continue;
                }
                entity.addPropertyValue(result.getBinding("p").getValue().stringValue(), object.stringValue());
            }
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing text annotations", e);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
        return entity;
    }

    private void setEnhancementData(Enhancement enhancement, BindingSet result) {
        if (result.hasBinding("confidence")) {
            enhancement.setConfidence(Double.parseDouble(result.getBinding("confidence").getValue().stringValue()));
        } else {
            enhancement.setConfidence(1.0);
        }
        enhancement.setLanguage(result.getBinding("language") != null ? result.getBinding("language").getValue().stringValue() : null);
    }

    @Override
    public Collection<TopicAnnotation> parseTopicAnnotation() throws EnhancementParserException {
        ArrayListMultimap relations = ArrayListMultimap.create();
        HashMap enhancementsByUri = Maps.newHashMap();
        try {
            RepositoryConnection conn = this.repository.getConnection();
            conn.begin();
            Collection<TopicAnnotation> tas = this.parseTopicAnnotations(conn, (Multimap<Enhancement, String>)relations, enhancementsByUri);
            Collection<Enhancement> result = this.resolveRelations((Multimap<Enhancement, String>)relations, conn);
            for (TopicAnnotation ta : tas) {
                if (result.contains(ta)) continue;
                result.add(ta);
            }
            conn.close();
            return result;
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
    }

    private Collection<TopicAnnotation> parseTopicAnnotations(RepositoryConnection conn, Multimap<Enhancement, String> relations, Map<String, Enhancement> enhancementsByUri) throws EnhancementParserException {
        HashSet tas = Sets.newHashSet();
        String topicAnnotationsQuery = "PREFIX fise: <http://fise.iks-project.eu/ontology/> \nPREFIX dct: <http://purl.org/dc/terms/> \nPREFIX entityhub: <http://stanbol.apache.org/ontology/entityhub/entityhub#> \nSELECT * { \n  ?annotation a fise:TopicAnnotation . \n\t OPTIONAL { fise:confidence ?confidence } \n  OPTIONAL { ?language a dct:language  } \n  OPTIONAL { ?annotation dct:relation ?relation } \n  OPTIONAL { ?annotation fise:entity-label ?entityLabel } \n  OPTIONAL { ?annotation fise:entity-reference ?entityReference } \n  OPTIONAL { ?annotation entityhub:site ?site } \n}";
        try {
            TupleQueryResult topicAnnotationsResults = conn.prepareTupleQuery(QueryLanguage.SPARQL, topicAnnotationsQuery).evaluate();
            while (topicAnnotationsResults.hasNext()) {
                BindingSet result = (BindingSet)topicAnnotationsResults.next();
                String uri = result.getBinding("annotation").getValue().stringValue();
                Enhancement topicAnnotation = enhancementsByUri.get(uri);
                if (topicAnnotation == null) {
                    topicAnnotation = new TopicAnnotation();
                    enhancementsByUri.put(uri, topicAnnotation);
                }
                this.setTopicAnnotationData((TopicAnnotation)topicAnnotation, result, conn, relations);
                if (tas.contains(topicAnnotation)) continue;
                tas.add((TopicAnnotation)topicAnnotation);
            }
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new EnhancementParserException("Error parsing text annotations", e);
        }
        catch (RepositoryException e) {
            throw new EnhancementParserException("Error querying the RDF Model obtained as Service Response", e);
        }
        return tas;
    }

    private void setTopicAnnotationData(TopicAnnotation topicAnnotation, BindingSet result, RepositoryConnection conn, Multimap<Enhancement, String> relations) {
        String nextRelationUri;
        if (!relations.containsKey((Object)topicAnnotation)) {
            this.setEnhancementData(topicAnnotation, result);
            if (result.hasBinding("entityLabel")) {
                Binding entityLabel = result.getBinding("entityLabel");
                topicAnnotation.setTopicLabel(entityLabel.getValue().stringValue());
                if (!result.hasBinding("language") && entityLabel.getValue() instanceof Literal) {
                    topicAnnotation.setLanguage(((Literal)entityLabel.getValue()).getLanguage());
                }
            }
            if (result.hasBinding("entityReference")) {
                topicAnnotation.setTopicReference(result.getBinding("entityReference").getValue().stringValue());
            }
            if (result.hasBinding("relation")) {
                String nextRelationUri2 = result.getBinding("relation").getValue().stringValue();
                relations.put((Object)topicAnnotation, (Object)nextRelationUri2);
            }
            if (result.hasBinding("site")) {
                topicAnnotation.setDataset(result.getBinding("site").getValue().stringValue());
            }
        } else if (result.hasBinding("relation") && !relations.containsEntry((Object)topicAnnotation, (Object)(nextRelationUri = result.getBinding("relation").getValue().stringValue()))) {
            relations.put((Object)topicAnnotation, (Object)nextRelationUri);
        }
    }
}

