/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis.model;

import io.redlink.sdk.analysis.AnalysisRequest;
import io.redlink.sdk.impl.analysis.model.EnhancementParserException;
import io.redlink.sdk.impl.analysis.model.EnhancementsParser;
import io.redlink.sdk.impl.analysis.model.RDFStructureParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.util.RDFInserter;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public final class EnhancementsParserFactory {
    private static final String REDLINK = "X-Redlink-Instance";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EnhancementsParser createDefaultParser(Response response) throws EnhancementParserException {
        String result = (String)response.readEntity(String.class);
        ParserConfig config = new ParserConfig();
        config.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        String uri = response.getHeaderString(REDLINK);
        if (uri == null || uri.isEmpty()) {
            uri = UUID.randomUUID().toString();
        }
        try {
            SailRepository repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            try (RepositoryConnection con = repository.getConnection();){
                con.begin();
                RDFParser p = Rio.createParser((RDFFormat)RDFFormat.forMIMEType((String)response.getMediaType().toString()), (ValueFactory)repository.getValueFactory());
                p.setRDFHandler((RDFHandler)new RDFInserter(con));
                p.setParserConfig(config);
                p.parse((Reader)new StringReader(result), uri);
                con.commit();
            }
            return new RDFStructureParser((Repository)repository);
        }
        catch (IOException | RepositoryException | RDFParseException | UnsupportedRDFormatException e) {
            throw new EnhancementParserException("Error Parsing Enhancement Structure", e);
        }
    }

    public static final EnhancementsParser createParser(Response response) throws EnhancementParserException {
        String type = response.getMediaType().getType() + "/" + response.getMediaType().getSubtype();
        AnalysisRequest.OutputFormat format = AnalysisRequest.OutputFormat.get(type);
        switch (format) {
            default: 
        }
        return EnhancementsParserFactory.createDefaultParser(response);
    }
}

