/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import io.redlink.sdk.impl.analysis.model.Enhancement;
import io.redlink.sdk.impl.analysis.model.Entity;
import io.redlink.sdk.impl.analysis.model.EntityAnnotation;
import io.redlink.sdk.impl.analysis.model.TextAnnotation;
import io.redlink.sdk.impl.analysis.model.TopicAnnotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Enhancements
implements Iterable<Enhancement> {
    private Multimap<Class<? extends Enhancement>, Enhancement> enhancements = ArrayListMultimap.create();
    private Map<String, Entity> entities = Maps.newLinkedHashMap();
    private Collection<String> languages = Sets.newHashSet();

    Enhancements() {
    }

    @Override
    public Iterator<Enhancement> iterator() {
        return this.getEnhancements().iterator();
    }

    public Collection<Enhancement> getEnhancements() {
        return Collections.unmodifiableCollection(this.enhancements.values());
    }

    void setEnhancements(Collection<Enhancement> enhancements) {
        for (Enhancement e : enhancements) {
            this.addEnhancement(e);
        }
    }

    void addEnhancement(Enhancement enhancement) {
        this.enhancements.put(enhancement.getClass(), (Object)enhancement);
        if (enhancement instanceof EntityAnnotation) {
            EntityAnnotation ea = (EntityAnnotation)enhancement;
            this.entities.put(ea.getEntityReference().getUri(), ea.getEntityReference());
        }
    }

    public Collection<TextAnnotation> getTextAnnotations() {
        Collection result = this.enhancements.get(TextAnnotation.class);
        return result;
    }

    public Collection<EntityAnnotation> getEntityAnnotations() {
        Collection result = this.enhancements.get(EntityAnnotation.class);
        return result;
    }

    public Collection<Entity> getEntities() {
        return Collections.unmodifiableCollection(this.entities.values());
    }

    public Entity getEntity(String URI2) {
        return this.entities.get(URI2);
    }

    public Collection<EntityAnnotation> getEntityAnnotations(TextAnnotation ta) {
        Collection<EntityAnnotation> eas = this.getEntityAnnotations();
        HashSet result = Sets.newHashSet();
        for (EntityAnnotation ea : eas) {
            if (ea.getRelations() == null || !ea.getRelations().contains(ta)) continue;
            result.add(ea);
        }
        return result;
    }

    public Collection<Entity> getEntitiesByConfidenceValue(Double confidenceValue) {
        Collection<EntityAnnotation> sortedEas = this.getEntityAnnotationsByConfidenceValue(confidenceValue);
        return Collections2.transform(sortedEas, (Function)new Function<EntityAnnotation, Entity>(){

            public Entity apply(EntityAnnotation ea) {
                return ea.getEntityReference();
            }
        });
    }

    public Collection<TextAnnotation> getTextAnnotationsByConfidenceValue(final Double confidenceValue) {
        return FluentIterable.from(this.getTextAnnotations()).filter((Predicate)new Predicate<TextAnnotation>(){

            public boolean apply(TextAnnotation e) {
                return e.confidence >= confidenceValue;
            }
        }).toImmutableList();
    }

    public Collection<EntityAnnotation> getEntityAnnotationsByConfidenceValue(final Double confidenceValue) {
        return FluentIterable.from(this.getEntityAnnotations()).filter((Predicate)new Predicate<EntityAnnotation>(){

            public boolean apply(EntityAnnotation e) {
                return e.confidence >= confidenceValue;
            }
        }).toImmutableList();
    }

    public Multimap<TextAnnotation, EntityAnnotation> getEntityAnnotationsByTextAnnotation() {
        ArrayListMultimap map = ArrayListMultimap.create();
        Collection<EntityAnnotation> eas = this.getEntityAnnotations();
        for (EntityAnnotation ea : eas) {
            if (ea.relations == null) continue;
            for (Enhancement e : ea.relations) {
                if (!(e instanceof TextAnnotation)) continue;
                map.put((Object)((TextAnnotation)e), (Object)ea);
            }
        }
        return map;
    }

    public Multimap<TextAnnotation, EntityAnnotation> getBestAnnotations() {
        Ordering o = new Ordering<EntityAnnotation>(){

            public int compare(EntityAnnotation left, EntityAnnotation right) {
                return Doubles.compare((double)left.confidence, (double)right.confidence);
            }
        }.reverse();
        ArrayListMultimap result = ArrayListMultimap.create();
        for (TextAnnotation ta : this.getTextAnnotations()) {
            List eas = o.sortedCopy(this.getEntityAnnotations(ta));
            if (eas.isEmpty()) continue;
            HashSet<EntityAnnotation> highest = new HashSet<EntityAnnotation>();
            Double confidence = ((EntityAnnotation)eas.get(0)).getConfidence();
            for (EntityAnnotation ea : eas) {
                if (ea.confidence < confidence) break;
                highest.add(ea);
            }
            result.putAll((Object)ta, highest);
        }
        return result;
    }

    public EntityAnnotation getEntityAnnotation(final String entityUri) {
        return (EntityAnnotation)Iterables.find(this.getEntityAnnotations(), (Predicate)new Predicate<EntityAnnotation>(){

            public boolean apply(EntityAnnotation ea) {
                return ea.getEntityReference().getUri().equals(entityUri);
            }
        });
    }

    public Collection<String> getLanguages() {
        return this.languages;
    }

    void setLanguages(Collection<String> languages) {
        this.languages = languages;
    }

    void addLanguage(String language) {
        this.languages.add(language);
    }

    public Collection<TopicAnnotation> getCategories() {
        Collection result = this.enhancements.get(TopicAnnotation.class);
        return result;
    }

    public boolean hasCategory(final String conceptURI) {
        return Iterables.any(this.getCategories(), (Predicate)new Predicate<TopicAnnotation>(){

            public boolean apply(TopicAnnotation ta) {
                return ta.getTopicReference().equals(conceptURI);
            }
        });
    }
}

