/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl.analysis;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.RedLink;
import io.redlink.sdk.analysis.AnalysisRequest;
import io.redlink.sdk.impl.RedLinkAbstractImpl;
import io.redlink.sdk.impl.analysis.model.EnhancementParserException;
import io.redlink.sdk.impl.analysis.model.Enhancements;
import io.redlink.sdk.impl.analysis.model.EnhancementsParser;
import io.redlink.sdk.impl.analysis.model.EnhancementsParserFactory;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedLinkAnalysisImpl
extends RedLinkAbstractImpl
implements RedLink.Analysis {
    private static final Logger logger = LoggerFactory.getLogger(RedLinkAnalysisImpl.class);

    public RedLinkAnalysisImpl(Credentials credentials) {
        super(credentials);
    }

    @Override
    public Enhancements enhance(AnalysisRequest request) {
        Response response = this.execEnhance(request);
        return this.parseResponse(response);
    }

    private Response execEnhance(AnalysisRequest request) {
        try {
            WebTarget target = this.credentials.buildUrl(this.getEnhanceUriBuilder(request.getAnalysis()));
            target = target.queryParam("in", new Object[]{request.getInputFormat()}).queryParam("out", new Object[]{request.getOutputFormat()}).queryParam("summary", new Object[]{request.getSummary()}).queryParam("thumbnail", new Object[]{request.getThumbnail()}).queryParam("enhancer.engines.dereference.ldpath", new Object[]{request.getLDpathProgram()});
            if (!request.getFieldsToDereference().isEmpty()) {
                Iterator<String> it = request.getFieldsToDereference().iterator();
                while (it.hasNext()) {
                    target = target.queryParam("enhancer.engines.dereference.fields", new Object[]{it.next()});
                }
            }
            Invocation.Builder httpRequest = target.request();
            httpRequest.accept(new MediaType[]{request.getOutputMediaType()});
            MediaType type = MediaType.TEXT_PLAIN_TYPE;
            if (!request.getInputMediaType().equals((Object)AnalysisRequest.InputFormat.TEXT.value())) {
                type = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            Entity entity = Entity.entity((Object)request.getContent(), (MediaType)type);
            logger.debug("Making Request to User Endpoint " + target.getUri().toString());
            long pre = System.currentTimeMillis();
            Response response = httpRequest.post(entity);
            long time = System.currentTimeMillis() - pre;
            logger.debug("Server Response Time " + time + " ms. Status: " + response.getStatus());
            if (response.getStatus() != 200) {
                String message = "Enhancement failed: HTTP error code " + response.getStatus() + ". Message: " + response.getStatusInfo().getReasonPhrase();
                logger.error(message);
                String stackTrace = (String)response.readEntity(String.class);
                logger.trace(stackTrace);
                throw new RuntimeException(message);
            }
            return response;
        }
        catch (IllegalArgumentException | MalformedURLException | UriBuilderException e) {
            throw new RuntimeException(e);
        }
    }

    private Enhancements parseResponse(Response response) {
        try {
            long pre = System.currentTimeMillis();
            EnhancementsParser parser = EnhancementsParserFactory.createParser(response);
            Enhancements enhancements = parser.createEnhancements();
            long time = System.currentTimeMillis() - pre;
            logger.debug("Response Parse Time: " + time + " ms");
            return enhancements;
        }
        catch (EnhancementParserException e) {
            throw new RuntimeException("Enhancement failed: " + e.getMessage(), e);
        }
    }

    private final UriBuilder getEnhanceUriBuilder(String analysis) {
        return this.initiateUriBuilding().path("analysis").path(analysis).path("enhance");
    }

    @Override
    public <T> T enhance(AnalysisRequest request, Class<T> responseType) {
        Object result = null;
        if (responseType.isAssignableFrom(Enhancements.class)) {
            AnalysisRequest finalRequest = request;
            if (request.getOutputMediaType().equals((Object)AnalysisRequest.OutputFormat.JSON.value()) || request.getOutputMediaType().equals((Object)AnalysisRequest.OutputFormat.XML.value())) {
                finalRequest = AnalysisRequest.builder().setAnalysis(request.getAnalysis()).setContent(request.getContent()).setInputFormat(AnalysisRequest.InputFormat.valueOf(request.getInputFormat())).setOutputFormat(AnalysisRequest.OutputFormat.TURTLE).setSummaries(request.getSummary()).setThumbnails(request.getThumbnail()).build();
            }
            result = this.enhance(finalRequest);
        } else if (responseType.isAssignableFrom(String.class)) {
            Response response = this.execEnhance(request);
            result = response.readEntity(String.class);
        } else {
            throw new UnsupportedOperationException("Unsupported Response Type" + responseType.getCanonicalName());
        }
        return responseType.cast(result);
    }
}

