/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl;

import io.redlink.sdk.impl.AbstractCredentials;
import io.redlink.sdk.util.ApiHelper;
import io.redlink.sdk.util.RedLinkClientBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultCredentials
extends AbstractCredentials {
    public static final String ENDPOINT = "https://api.redlink.io";
    public static final String KEY_PARAM = "key";
    public static final String DATAHUB = "http://data.redlink.io";
    private static Logger log = LoggerFactory.getLogger(DefaultCredentials.class);
    private final ResteasyClientBuilder clientBuilder = new RedLinkClientBuilder();

    public DefaultCredentials(String apiKey) {
        this(apiKey, ApiHelper.getApiVersion());
    }

    public DefaultCredentials(String apiKey, String version) {
        super(ENDPOINT, version, apiKey, DATAHUB);
        log.debug("created credentials over {}/{}", (Object)ENDPOINT, (Object)version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebTarget buildUrl(UriBuilder builder) throws MalformedURLException, IllegalArgumentException, UriBuilderException {
        URI uri = builder.queryParam(KEY_PARAM, new Object[]{this.apiKey}).build(new Object[0]);
        ResteasyClientBuilder resteasyClientBuilder = this.clientBuilder;
        synchronized (resteasyClientBuilder) {
            return this.clientBuilder.build().target(uri.toString());
        }
    }
}

