/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.sdk.impl;

import io.redlink.sdk.Credentials;
import io.redlink.sdk.impl.Status;
import io.redlink.sdk.impl.StatusError;
import java.net.MalformedURLException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

abstract class AbstractCredentials
implements Credentials {
    protected final String endpoint;
    protected final String version;
    protected final String apiKey;
    protected final String datahub;
    private Status status;

    AbstractCredentials(String endpoint, String version, String apiKey, String datahub) {
        this.endpoint = endpoint;
        this.version = version;
        this.apiKey = apiKey;
        this.datahub = datahub;
    }

    AbstractCredentials(String endpoint, String version, String apiKey) {
        this(endpoint, version, apiKey, endpoint.replace("api", "data").replace("https://", "http://"));
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getDataHub() {
        return this.datahub;
    }

    @Override
    public boolean verify() throws MalformedURLException {
        if (this.status == null) {
            this.status = this.getStatus();
        }
        return this.status.isAccessible();
    }

    @Override
    public synchronized Status getStatus() throws MalformedURLException {
        WebTarget target = this.buildUrl(UriBuilder.fromUri((String)this.getEndpoint()).path(this.getVersion()));
        Invocation.Builder request = target.request();
        request.accept(new String[]{"application/json"});
        try {
            Response response = request.get();
            if (response.getStatus() == 200) {
                return (Status)response.readEntity(Status.class);
            }
            StatusError error = (StatusError)response.readEntity(StatusError.class);
            throw new RuntimeException("Status check failed: HTTP error code " + error.getError() + "\n Endpoint: " + target.getUri().toString() + "\n Message: " + error.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Status check failed: " + e.getMessage(), e);
        }
    }
}

