/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.nlp.stanfordnlp.sentiment;

import io.redlink.nlp.stanfordnlp.sentiment.SentimentClassMapping;

public class LinearSentimentClassMapping
implements SentimentClassMapping {
    final int numClasses;
    final int minValue;
    final int maxValue;
    final double increment;

    public LinearSentimentClassMapping(int numClasses) {
        this(numClasses, -1, 1);
    }

    public LinearSentimentClassMapping(int numClasses, int minValue, int maxValue) {
        assert (numClasses > 1);
        assert (maxValue > minValue);
        this.numClasses = numClasses;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.increment = (double)(maxValue - minValue) / ((double)numClasses - 1.0);
    }

    @Override
    public double getIndexWeight(int index) {
        return (double)this.minValue + (double)index * this.increment;
    }
}

