/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.nlp.stanfordnlp.annotators;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import io.redlink.nlp.model.AnalyzedText;
import io.redlink.nlp.model.Section;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AnalyzedTextSectionAnnotator
implements Annotator {
    public void annotate(Annotation annotation) {
        AnalyzedText at = (AnalyzedText)annotation.get(AnalyzedTextAnnotation.class);
        if (at == null) {
            return;
        }
        LinkedList<Section> activeSections = new LinkedList<Section>();
        Iterator sections = at.getSections();
        if (!sections.hasNext()) {
            return;
        }
        if (annotation.containsKey(CoreAnnotations.TokensAnnotation.class)) {
            Section current = (Section)sections.next();
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            CoreLabel token = null;
            Iterator tokenIt = tokens.iterator();
            while ((current != null || !activeSections.isEmpty()) && tokenIt.hasNext()) {
                token = (CoreLabel)tokenIt.next();
                int start = token.beginPosition();
                while (current != null && current.getStart() <= start) {
                    activeSections.add(0, current);
                    current = sections.hasNext() ? (Section)sections.next() : null;
                }
                int end = token.endPosition() + (token.after() != null ? token.after().length() : 0);
                boolean isSectionEnd = false;
                Iterator sectionIt = activeSections.iterator();
                while (sectionIt.hasNext()) {
                    Section active = (Section)sectionIt.next();
                    if (active.getEnd() > end) continue;
                    isSectionEnd = true;
                    sectionIt.remove();
                }
                if (!isSectionEnd) continue;
                token.set(CoreAnnotations.ForcedSentenceEndAnnotation.class, (Object)true);
            }
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.singleton(CoreAnnotations.TokensAnnotation.class);
    }

    public static class AnalyzedTextAnnotation
    implements CoreAnnotation<AnalyzedText> {
        public Class<AnalyzedText> getType() {
            return AnalyzedText.class;
        }
    }
}

